#ifndef _RTN_GRAMMAR_H_
#define _RTN_GRAMMAR_H_

#include <vector>
#include <string>

#include <boost/filesystem/path.hpp>

#include <outilex/rtn_pattern.h>

class ling_def;


class rtn_grammar {

public:

  typedef rtn_pattern::input_type input_type;
  typedef rtn_pattern::output_type output_type;


  rtn_grammar(ling_def * ldef) : lingdef(ldef), patterns(), pat_map(), axiom(0) {}
  rtn_grammar(const boost::filesystem::path & path, ling_def * ldef);

  int start() const { return axiom; }
  const std::string & start_name() const { return patterns[axiom].name; }

  int size() const { return patterns.size(); }

  inline int get_pat_idx(const std::string & name) const;

  rtn_pattern & operator[](int no) { return patterns[no]; }
  const rtn_pattern & operator[](int no) const { return patterns[no]; }

  int add_pattern(const rtn_pattern & pattern);
  int add_pattern(const boost::filesystem::path & patternpath, const std::string & name);

  void write(const boost::filesystem::path & path) const;
  void write_xml(xmlwriter & writer) const;

  void read(const boost::filesystem::path & path);
  void read_xml(xmlNode * node);

public:
  ling_def * lingdef;
  std::vector<rtn_pattern> patterns;
  std::map<std::string, int> pat_map;
  int axiom;
};


int rtn_grammar::get_pat_idx(const std::string & name) const {
  std::map<std::string, int>::const_iterator it = pat_map.find(name);
  if (it == pat_map.end()) { return -1; }
  return it->second;
}


#endif
