#include <sstream>
#include <string>
#include <set>
#include <algorithm>
#include <cassert>

#include <boost/dynamic_bitset.hpp>

#include <outilex/xml.h>
#include <outilex/stringtok.h>
#include <outilex/disjoint.h>

#include <outilex/ref_attr.h>

using namespace std;
using namespace boost;


/* represents a set of values for a given enum attribute 
 * derives from virtual attr_val_set class (probably useless)
 * perhaps use a struct instead as we don't really use inheritance and RTTI ?
 */


#if 0
bool ref_val_set::in(const ref_val_set & a, const ref_val_set & b) {

  if (a.neg) {

    if (b.neg) { //2 negations, retourne vrai si toutes les formes niees dans b sont egalement niees dans a

      return std::includes(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end());

    } else { // a is negative (non borne) and b positive (borne), return false

      return false;
    }

  } else { // a is positive

    if (b.neg) { // and b is negative, check that all form specified in a are not negated in b

      return disjoint(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end()); 

    } else { // both are positive, return true if all form specified in a are also present in b

      return std::includes(b.vals.begin(), b.vals.end(), a.vals.begin(), a.vals.end());
    }
  }

  assert("never reached!!!" && 0);
  return false;
}


bool ref_val_set::intersect(const ref_val_set & a, const ref_val_set & b) {

  if (a.neg) {

    if (b.neg) { //2 negations, retourne vrai 

      return true;

    }
    /* a is negative and b positive (borne),
     * return vrai si il existe un forme dans b non niee dans a
     */

    return ! std::includes(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end());

  } else { // a is positive

    if (b.neg) { // symetric

      return ! std::includes(b.vals.begin(), b.vals.end(), a.vals.begin(), a.vals.end());

    } 
    /* both are positive,
     * return true if there is some form in a, also present in b
     */
    return ! disjoint(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end());
  }

  assert("never reached!!!" && 0);
  return false;
}




void ref_val_set::set_inter(const ref_val_set & a, const ref_val_set & b) {

  if (& a == this) { ref_val_set aa = a; return set_inter(aa, b); }
  if (& b == this) { ref_val_set bb = b; return set_inter(a, bb); }

  if (! a.neg) {

    if (! b.neg) { // a and b are positive, compute normal intersection

      neg = false;
      vals.clear();
      set_intersection(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end(),
                       inserter(vals, vals.begin()));

    } else { // a is pos and b is neg, make result with all string in a which are not present in b

      neg = false;
      vals.clear();
      set_difference(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end(), inserter(vals, vals.begin()));
    }

  } else { // a is negative

    if (! b.neg) { // b is pos, compute string in b which are not in a

      neg = false;
      vals.clear();
      set_difference(b.vals.begin(), b.vals.end(), a.vals.begin(), a.vals.end(), inserter(vals, vals.begin()));

    } else { // a and b are negative, make an union

      neg = true;
      vals.clear();
      ::set_union(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end(), inserter(vals, vals.begin()));
    }
  }
}


void ref_val_set::set_union_(const ref_val_set & a, const ref_val_set & b) {

  vals.clear();

  if (a.neg) {
    if (b.neg) {
    
      neg = true;
      set_intersection(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end(), 
                       inserter(vals, vals.begin()));
      
    } else {
      neg = true;
      set_difference(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end(),
                     inserter(vals, vals.begin()));
    }
  
  } else { // a.pos

    if (b.neg) {
      neg = true;
      set_difference(b.vals.begin(), b.vals.end(), a.vals.begin(), a.vals.end(),
                     inserter(vals, vals.begin()));
    } else {
      neg = false;
      ::set_union(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end(),
                  inserter(vals, vals.begin()));
    }
  }
}


void ref_val_set::set_minus(const ref_val_set & a, const ref_val_set & b) {

  if (& a == this) { ref_val_set aa = a; return set_minus(aa, b); }
  if (& b == this) { ref_val_set bb = b; return set_minus(a, bb); }

  vals.clear();

  if (a.neg) {
  
    if (b.neg) { // !pomme!poire \ !pomme!orange = !pomme!poire inter pomme,orange = orange

      neg = false;
      
      set_difference(b.vals.begin(), b.vals.end(), a.vals.begin(), a.vals.end(),
                     inserter(vals, vals.begin()));
    } else { //!pomme!poire \ pomme,orange = !pomme!poire!orange
      
      neg = true;
      set_union(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end(),
                inserter(vals, vals.begin()));
    }
  } else {
  
    if (b.neg) { // pomme,poire \ !pomme!orange = pomme,poire inter pomme,orange = pomme

      neg = false;
      set_intersection(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end(),
                       inserter(vals, vals.begin()));
    
    } else { // pomme,poire \ pomme,orange = poire

      neg = false;
      set_difference(a.vals.begin(), a.vals.end(), b.vals.begin(), b.vals.end(),
                     inserter(vals, vals.begin()));
    }
  }
}

bool ref_val_set::match(int v) const {
  if (neg) {
    return vals.find(v) == vals.end();
  } else { return vals.find(v) != vals.end(); }
}
#endif



// bitset de taille non bornee, la valeur des bits pour les
// positions n >= size(), est la valeur du bit a la position size()-1
// (i.e. pour les feats negative '!hum!conc', la valeur est 1,
//  pour les feats positive 'hum|conc', c'est zero.)

class ref_val_set : public attr_val_set {
public:

  dynamic_bitset<> vals;

  ref_val_set(int size) : vals(size) {}

  int size() const { return vals.size(); }

  bool back() const {
    return vals.test(vals.size() - 1);
  }

  bool test(size_t i) const {
    i = std::min(i, vals.size() - 1);
    return vals.test(i);
  }

  void set(int i, bool val = true) {
    if (test(i) == val) { return; }
    if (vals.size() <= i) { resize(i + 1); }
    vals.set(i, val);
  }
  
  void resize(int sz) {
    vals.resize(sz, vals.test(vals.size() - 1));
  }
};




/* Implementation of reference attribute type
 */


ref_attr_type::ref_attr_type(const string & n) : name(n), values() {

  /* add empty unset, represents unset value  (== 0) */

  string unset = "unset";
  values.add(unset, unset);
}


void ref_attr_type::read_XML(xmlNodePtr node) {

  char * text = xmlGetProp(node, "name");
  name =  text;
  xmlFree(text);

  values.clear();

  /* add empty unset, represents unset value  (== 0) */

  string unset = "unset";
  values.add(unset, unset);
}


/* ref attribute loader routines */

attr_type * ref_attr_loader(xmlNodePtr node) {
  return new ref_attr_type(node);
}

//static attr_type_registerer ref_registration("reference", ref_attr_loader);


const string & ref_attr_type::get_name() const { return name; }


// return unspec val set (== 111111..10)
attr_val_set * ref_attr_type::new_val_set() {
  ref_val_set * res = new ref_val_set(2); // val = 00
  res->set(1); // val = 10 = 111..10
  return res;
}


attr_val_set * ref_attr_type::new_val_set(int val) {

  if (val == -1) { // everything but unset (== UNSPEC)
    return new_val_set();
  } 

  assert(val < values.size());

  ref_val_set * v = new ref_val_set(val + 2);
  v->set(val);

  return v;
}


attr_val_set * ref_attr_type::new_val_set(const attr_val_set * vs) {
  return new ref_val_set(*((const ref_val_set *) vs));
}


attr_val_set * ref_attr_type::new_val_set(const string & text) {

  if (text.empty()) { // return empty (0)
    return new ref_val_set(1);
  }

  vector<string> vec;
  vector<int> v;
  stringtok(text, "!|", back_inserter(vec));
  v.resize(vec.size());

  int max = 0;
  for (int i = 0; i < vec.size(); ++i) {
    v[i] = values.add_if_not_here(vec[i], vec[i]);
    if (v[i] > max) { max = v[i]; }
  }

  bool neg = (text[0] == '!');

  ref_val_set * res = new ref_val_set(max + 2);
 
  for (int i = 0; i < v.size(); ++i) {
    res->set(v[i]);
  }
  if (neg) { res->vals.flip(); }

  return res;
}


void ref_attr_type::del_val_set(attr_val_set * vs) {
  delete (ref_val_set *) vs;
}

void ref_attr_type::copy_val_set(attr_val_set *& _dest, const attr_val_set * _src) {

  // assert(_dest && _src);

  *((ref_val_set *)_dest) = *((const ref_val_set *)_src);
}


bool ref_attr_type::is_val_set_empty(const attr_val_set * vs) {
  return ((ref_val_set *) vs)->vals.none();
}

bool ref_attr_type::is_val_set_unspec(const attr_val_set * vs) {
  const ref_val_set * evs = (const ref_val_set *) vs;
  return (evs->vals.count() == evs->size() - 1) && (evs->test(0) == false);
}



void ref_attr_type::clear_val_set(attr_val_set *& vs) {
  ((ref_val_set *) vs)->vals.clear();
}

void ref_attr_type::set_val_set(attr_val_set *& vs) { // unspec (all but unset (0))
  ((ref_val_set *) vs)->vals.set();
  ((ref_val_set *) vs)->vals.reset(0);
}


void ref_attr_type::unset_val_set(attr_val_set *& vs) {
  ((ref_val_set *) vs)->vals.reset();
  ((ref_val_set *) vs)->vals.set(0);
}




bool ref_attr_type::in(const attr_val_set * _a, const attr_val_set * _b) {
 
  const ref_val_set * a = (const ref_val_set *) _a;
  const ref_val_set * b = (const ref_val_set *) _b;

  int sz = std::max(a->size(), b->size());

  for (int i = 0; i < sz; ++i) {
    if (a->test(i) && ! b->test(i)) { return false; }
  }
  return true;
}


bool ref_attr_type::intersect(const attr_val_set * _a, const attr_val_set * _b) {
 
  const ref_val_set * a = (const ref_val_set *) _a;
  const ref_val_set * b = (const ref_val_set *) _b;

  int sz = std::max(a->size(), b->size());

  for (int i = 0; i < sz; ++i) {
    if (a->test(i) && b->test(i)) { return true; }
  }
  return false;
}


attr_val_set * ref_attr_type::inter(const attr_val_set * _a, const attr_val_set * _b) {

  const ref_val_set * a = (const ref_val_set *) _a;
  const ref_val_set * b = (const ref_val_set *) _b;

  int sz = std::max(a->size(), b->size());

  ref_val_set * res = new ref_val_set(sz);

  for (int i = 0; i < sz; ++i) {
    res->set(i, a->test(i) && b->test(i));
  }

  return res;
}


attr_val_set * ref_attr_type::union_(const attr_val_set * _a, const attr_val_set * _b) {

  const ref_val_set * a = (const ref_val_set *) _a;
  const ref_val_set * b = (const ref_val_set *) _b;

  int sz = std::max(a->size(), b->size());

  ref_val_set * res = new ref_val_set(sz);

  for (int i = 0; i < sz; ++i) {
    res->set(i, a->test(i) || b->test(i));
  }

  return res;
}

attr_val_set * ref_attr_type::minus(const attr_val_set * _a, const attr_val_set * _b) {

  const ref_val_set * a = (const ref_val_set *) _a;
  const ref_val_set * b = (const ref_val_set *) _b;

  int sz = std::max(a->size(), b->size());

  ref_val_set * res = new ref_val_set(sz);

  for (int i = 0; i < sz; ++i) {
    res->set(i, a->test(i) & ~(b->test(i)));
  }

  return res;
}

bool ref_attr_type::equal(const attr_val_set * _a, const attr_val_set * _b) {

  const ref_val_set * a = (const ref_val_set *) _a;
  const ref_val_set * b = (const ref_val_set *) _b;

  int sz = std::max(a->size(), b->size());

  for (int i = 0; i < sz; ++i) {
    if (a->test(i) != b->test(i)) { return false; }
  }

  return true;
}

bool ref_attr_type::match(int v, const attr_val_set * vs) {
  return ((ref_val_set *) vs)->test(v);
}


void ref_attr_type::register_shortcut_values(attr_def * attr, pos_def * pos) { }


void ref_attr_type::dump_val_set_text(const attr_val_set * vs, std::ostream & os) const {

  const ref_val_set * evs = (const ref_val_set *) vs;

  if (evs->vals.count() == evs->vals.size()) { // everything!
    os << '!';
    return;
  }
  if (evs->vals.none()) { return; }

  if (evs->back()) { // neg
    for (int i = 0; i < evs->size(); ++i) {
      if (evs->test(i) == false) {
        os << "!" << values[i];
      }
    }
  } else {
    bool first = true;
    for (int i = 0; i < evs->size(); ++i) {
      if (evs->test(i)) {
        if (!first) { os << '|'; }
        os << values[i];
        first = false;
      }
    }
  }
}



int ref_attr_type::get_value(const string & txt) const {
  return values.add_if_not_here(txt, txt);
}

string ref_attr_type::get_val_text(int val) const {
  return values[val];
}

void ref_attr_type::dump_val_text(int val, ostream & os) const {
  os << values[val];
}

