#ifndef _VOID_ATTR_TYPE_H_
#define _VOID_ATTR_TYPE_H_

#include <string>

#include <outilex/attr_type.h>

class void_attr_type : public attr_type {

  std::string name;

public:

  void_attr_type(const std::string & _name) : name(_name) {}
  ~void_attr_type() {}

  const std::string & get_name() const;

  attr_val_set * new_val_set();
  attr_val_set * new_val_set(int val);
  attr_val_set * new_val_set(const attr_val_set * vs);
  attr_val_set * new_val_set(const std::string & str);

  void del_val_set(attr_val_set * vs);

  void copy_val_set(attr_val_set *& _dest, const attr_val_set * _src);

  bool is_val_set_empty(const attr_val_set * vs);
  bool is_val_set_unspec(const attr_val_set * vs);

  void clear_val_set(attr_val_set *& vs);
  void unset_val_set(attr_val_set *& vs);
  void set_val_set(attr_val_set *& vs);

  bool in(const attr_val_set * a, const attr_val_set * b);
  bool intersect(const attr_val_set * a, const attr_val_set * b);

  attr_val_set * inter(const attr_val_set * _a, const attr_val_set * _b);
  attr_val_set * union_(const attr_val_set * _a, const attr_val_set * _b);
  attr_val_set * minus(const attr_val_set * _a, const attr_val_set * _b);

  bool equal(const attr_val_set * a, const attr_val_set * b);

  bool match(int v, const attr_val_set * vs);

  void dump_val_set_text(const attr_val_set * vs, std::ostream & os) const;
  std::string get_val_set_text(const attr_val_set * vs) const;

  int get_value(const std::string & txt) const;
  std::string get_val_text(int val) const;
  void dump_val_text(int val, std::ostream & os) const;
  
};

#endif

