#ifndef _FORM_SET_H_
#define _FORM_SET_H_


#include <set>
#include <string>

#include <outilex/xml.h>

/* represent a set of strings,
 * if negative represents the set of all string which are not present in vals
 * default constructor set neg to true and vals to empty set, so that the set matchs
 * with 'any string'
 */

class form_set {

  bool neg;
  std::set<std::string> vals;

public:

  form_set() : neg(true), vals() {}

  form_set(const form_set & fs) : neg(fs.neg), vals(fs.vals) {}

  /* copy assignment
   */
  form_set & operator=(const form_set & fs) { neg = fs.neg; vals = fs.vals; return *this; }

  /* assign the set to { form }
   */

  form_set & operator=(const std::string & form) {
    neg = false; vals.clear(); vals.insert(form); return *this;
  }


  /* add form to the set
   */
  
  form_set & operator+=(const std::string & form);


  /* int cast operator */
  operator int() const { return empty() ? 0 : 1; }

  bool operator!() const { return empty(); }


  /* comparaison operators */

  bool operator==(const form_set & b) const {
    if (neg != b.neg) { return false; }
    return vals == b.vals;
  }

  bool operator!=(const form_set & b) const {
    return ! (*this == b);
  }

  /* clear the set, make it recognize no string */

  void clear() { vals.clear(); neg = false; }

  /* make the set recognize every string */

  void unspec() { vals.clear(); neg = true; }

  bool empty() const { return (! neg) && vals.empty(); }
  bool is_unspec() const { return neg && vals.empty(); }


  /* int assignement operator
   */

  form_set & operator=(int v) {
    if (v == 0) { // empty set
      clear();
    } else {
      unspec();
    }
    return *this;
  }


  /* is a a subset of b ? */

  static bool in(const form_set & a, const form_set & b);

  bool intersect(const form_set & b) const;


  /* set form_set to the intersection of a and b */

  bool set_inter(const form_set & a, const form_set & b);
  void set_inter(const form_set & b);

  void operator&=(const form_set & b) { set_inter(b); }

  bool set_minus(const form_set & a, const form_set & b);
  void set_minus(const form_set & b);

  void operator-=(const form_set & b) { set_minus(b); }


  /* return true if form is described in this form_set */

  bool match(const std::string & form) const {
    if (neg) {
      return vals.find(form) == vals.end();
    } else { return vals.find(form) != vals.end(); }
  }


  /* serialisation */

  void read_XML(xmlNodePtr node);
  void write_XML(xmlwriter & os, const std::string & name) const;

  void dump_text(std::ostream & os) const;
  void read_text(const std::string & text);

  void dump_unescaped(std::ostream & os) const;
};




/* return true if a is a subset of b */

inline bool in(const form_set & a, const form_set & b) {
  return form_set::in(a, b);
}


inline bool match(const std::string & f, const form_set & s) { return s.match(f); }

inline bool inter(const form_set & a, const form_set & b, form_set & res) {
  return res.set_inter(a, b);
}

/*
inline form_set inter(const form_set & a, const form_set & b) {
  form_set res;
  inter(a, b, res);
  return res;
}

*/

inline bool minus(const form_set & a, const form_set & b, form_set & res) {
  return res.set_minus(a, b);
}

/*
inline form_set minus(const form_set & a, const form_set & b) {
  form_set res;
  minus(a, b, res);
  return res;
}
*/

inline std::ostream & operator<<(std::ostream & os, const form_set & fs) {
  fs.dump_unescaped(os); return os;
}

inline form_set & form_set::operator+=(const std::string & form) {
  if (neg) {
    std::set<std::string>::iterator it = vals.find(form);
    if (it != vals.end()) { vals.erase(it); }
  } else {
    vals.insert(form);
  }
  return *this;
}

#endif

