#ifndef _ENUM_ATTR_H_
#define _ENUM_ATTR_H_

#include <boost/dynamic_bitset.hpp>


#include <outilex/lingdef.h>


/* enumeration attribute type implementation
 */

class enum_attr_type : public attr_type {

protected:

  typedef boost::dynamic_bitset<> enum_val_set;

  std::string name;

  std::vector<std::string> value_name;
  std::map<std::string, int> name_to_value;


  enum_attr_type() : name(), value_name(), name_to_value() {}

  int nb_values() const { return value_name.size(); }

  void read_XML(xmlNodePtr node);

public:

  enum_attr_type::enum_attr_type(xmlNodePtr node) : name(), value_name(), name_to_value() {
    read_XML(node);
  }

  const std::string & get_name() const;

  attr_val_set * new_val_set();
  attr_val_set * new_val_set(int val);
  attr_val_set * new_val_set(const attr_val_set * vs);
  attr_val_set * new_val_set(const std::string & str);

  void del_val_set(attr_val_set * vs);

  void copy_val_set(attr_val_set * _dest, const attr_val_set * _src);

  bool is_val_set_empty(attr_val_set * vs);
  bool is_val_set_unspec(attr_val_set * vs);

  void clear_val_set(attr_val_set * vs);
  void unset_val_set(attr_val_set * vs);
  void set_val_set(attr_val_set * vs);

  bool in(const attr_val_set * a, const attr_val_set * b);
  bool intersect(const attr_val_set * a, const attr_val_set * b);

  attr_val_set * inter(const attr_val_set * _a, const attr_val_set * _b);
  attr_val_set * union_(const attr_val_set * _a, const attr_val_set * _b);
  attr_val_set * minus(const attr_val_set * _a, const attr_val_set * _b);

  bool equal(const attr_val_set * a, const attr_val_set * b);
  bool match(int v, const attr_val_set * vs);

  void register_shortcut_values(attr_def * attr, pos_def * pos);

  int get_value(const std::string & txt) const;


  std::string get_val_text(int val) const;
  void dump_val_text(int val, std::ostream & os) const;

  std::string get_val_set_text(const attr_val_set * vs) const;
  void dump_val_set_text(const attr_val_set * vs, std::ostream & os) const;


  void dump_feat_val(const std::string & attrname, int val, bool shortcut, std::ostream & os) const;

  void dump_feat_val_set(const std::string & attrname, const attr_val_set * vs,
                         bool shortcut, std::ostream & os) const;
};


#endif
