#include <string>

#include <outilex/xml.h>

#include <outilex/lingdef.h>
#include <outilex/feat_set.h>

#include <outilex/attr_type.h>
#include <outilex/void_attr.h>


/* don't know where to put this ? */



using namespace std;


feat_set::feat_set(attr_type * type, attr_val_set * val)
  : type(type), val(type->new_val_set(val)) {}

feat_set::feat_set(attr_type * type, int val)
  : type(type), val(type->new_val_set(val)) {}

feat_set::feat_set(attr_type * type, const std::string & val)
  : type(type), val(type->new_val_set(val)) {}

feat_set::feat_set(attr_def * attr, const std::string & val)
  : type(attr->type), val(type->new_val_set(val)) {}


feat_set & feat_set::operator=(const std::string & value) {
  type->del_val_set(val);
  val = type->new_val_set(value);
  return *this;
}


feat_set::feat_set(attr_type * type)
  : type(type), val(type->new_val_set()) { }

feat_set::feat_set(attr_def * attr)
  : type(attr->type), val(type->new_val_set()) { }

feat_set::feat_set(const feat_set & fs)
  : type(fs.type), val(type->new_val_set(fs.val)) {}

feat_set::feat_set(xmlNodePtr node, ling_def * ldef)
  : type(void_attribute_type), val(type->new_val_set()) {
  read_XML(node, ldef);
}



/* copy assignment
 */
feat_set & feat_set::operator=(const feat_set & fs) {
  type->del_val_set(val); 
  type = fs.type;
  val = type->new_val_set(fs.val);
  return *this;
}


//feat_set::~feat_set() { type->del_val_set(val); }
void feat_set::delete_val() { type->del_val_set(val); }


/* empty the set */

void feat_set::clear() { type->clear_val_set(val); }

void feat_set::unset() { type->unset_val_set(val); }

void feat_set::set()   { type->set_val_set(val); }


void feat_set::set(attr_type * t, int v) {
  type->del_val_set(val);
  type = t;
  val = type->new_val_set(v);
}


void feat_set::set(attr_type * t, const std::string & v) {
  type->del_val_set(val);
  type = t;
  val = type->new_val_set(v);
}


/* is it the empty set ? */

bool feat_set::empty() const { return type->is_val_set_empty(val); }

/* is is unspec */

bool feat_set::is_unspec() const { return type->is_val_set_unspec(val); }


/* subset */

bool feat_set::in(const feat_set & a, const feat_set & b) {
  if (a.type != b.type) { return false; }
  return a.type->in(a.val, b.val);
}

bool feat_set::intersect(const feat_set & b) const {
  if (type != b.type) { return false; }
  return type->intersect(val, b.val);
}


/* intersection */

void feat_set::set_inter(const feat_set & a, const feat_set & b) {

  if (a.type != b.type) { clear(); return; }

  if (& a == this) { set_inter(b); return; }
  if (& b == this) { set_inter(a); return; }

  type->del_val_set(val);
  type = a.type;
  val = type->inter(a.val, b.val);
}


void feat_set::set_inter(const feat_set & b) {

  if (type != b.type) { clear(); return; }

  attr_val_set * nval = type->inter(val, b.val);
  type->del_val_set(val);
  val = nval;
}

/* union */

void feat_set::set_union(const feat_set & a, const feat_set & b) {

  if (& a == this) { set_union(b); return; }
  if (& b == this) { set_union(a); return; }

  if (a.type != b.type) { throw runtime_error("featset::union incompatible feat types"); }

  type->del_val_set(val);
  type = a.type;
  val = type->union_(a.val, b.val);
}

void feat_set::set_union(const feat_set & b) {

  if (type != b.type) { throw runtime_error("featset::union incompatible feat types"); }

  attr_val_set * nval = type->union_(val, b.val);
  type->del_val_set(val);
  val = nval;
}


/* complementation */

void feat_set::set_minus(const feat_set & a, const feat_set & b) {

  if (& a == this) { set_minus(b); return; }
  if (& b == this) { set_minus(a); return; }

  if (a.type != b.type) { throw runtime_error("featset::minus incompatible feat types"); }

  type->del_val_set(val);
  type = a.type;
  val = type->minus(a.val, b.val);
}

void feat_set::set_minus(const feat_set & b) {

  if (type != b.type) { throw runtime_error("featset::minus incompatible feat types"); }

  attr_val_set * nval = type->minus(val, b.val);
  type->del_val_set(val);
  val = nval;
}

bool feat_set::match(int v) const {
  return type->match(v, val);
}


bool feat_set::operator==(const feat_set & b) const {
  if (type != b.type) { return false; }
  return type->equal(val, b.val);
}


#if 0
bool feat_set::operator<(const feat_set & b) const {
  if (type != b.type) {
    return type < b.type;
  }
  return type->less_than(val, b.val);
}
#endif


void feat_set::read_XML(xmlNodePtr node, ling_def * ldef) {

  /* first delete old val_set */

  type->del_val_set(val);

  char * text = xmlGetProp(node, "type");
  string attrname(text);
  xmlFree(text);

  type = ldef->get_attr_type(attrname);

  if (type == NULL) { throw xml_parse_error("featset: unknown attribute type '" + attrname + "'"); }

  text = xmlGetProp(node, "value");

  val = type->new_val_set(text); 
  xmlFree(text);
}


void feat_set::write_XML(xmlwriter & writer) const {
  writer.start_element(xml_name());
  writer.write_attribute("type", type->get_name());
  writer.write_attribute("value", type->get_val_set_text(val));
  writer.end_element();
}


#if 0
void feat_set::read_text(const string & text, const pos_def * pos) {

  /* first delete old val_set */

  attr->del_val_set(val);

  string::size_type eq = text.find('=');
  if (eq == string::npos) { // lookup for a shortcut value
    int v;
    if (pos->find_shortcut_value(text, attr, v) == false) {
      throw xml_parse_error("featset: unknow feat : " + text);
    }
    val = attr->new_val_set(v);

    return;
  }

  // assume text is of the form +'attrname'='attrvalue'
 
  if (text[0] != '+') { throw runtime_error("featset::readtext: bad format : " + text); }

  attr = pos->get_attr(text.substr(1, eq - 1));
  if (attr == NULL) { throw xml_parse_error("featset: unknow attribute : " + text.substr(1, eq - 1)); }

  val = attr->new_val_set(text.substr(eq + 1));
}
#endif

void feat_set::dump_val(ostream & os) const { type->dump_val_set_text(val, os); }

string feat_set::get_val_text() const { return type->get_val_set_text(val); }

void feat_set::dump_text(ostream & os) const {
  os << type->get_name() << '@' << type->get_val_set_text(val);
}

