#ifndef _LG_TABLE_H_
#define _LG_TABLE_H_

#include <vector>
#include <set>
#include <map>

#include <boost/filesystem/path.hpp>


class lg_table {

public:

  typedef enum {
    normal_param, neg_param, prefix_param, rowid_param, default_param, invalid_param
  } param_type;


  lg_table(const boost::filesystem::path & path, char fieldsep = ',')
    : ncol(0), properties(), defaults(), table(), not_found() {
    load(path, fieldsep);
  }

  inline int size() const { return table.size(); }

  bool resolve(int entry, const std::string & param, std::string & res) const;

  bool resolve_elementary_parameter(int e, const std::string & param,
                                    param_type type, std::string & res) const;

  bool resolve_prefix_parameter(int e, const std::string & param, std::string & res) const;

  static param_type lg_table::get_parameter_type(const std::string & param);

  void load(const boost::filesystem::path & path, char fieldsep = ',');

  int ncol;
  std::map<std::string, int> properties;
  std::vector<std::string> defaults;
  std::vector<std::vector<std::string> > table;
  mutable std::set<std::string> not_found;
};

#endif
