#include <iostream>
#include <stdexcept>
#include <vector>
#include <iterator>

#include <boost/progress.hpp>

#include <unistd.h>
#include <libxml/xmlreader.h>

#include <outilex/dic_entry.h>
#include <outilex/xml.h>

using namespace std;
using namespace boost;



void my_unexpected() {
  cerr << "unexpected exception!\n";
  terminate();
}




void usage(char * progname) {
  cout << "usage : " << progname << " [-validate] [-verbose] <dicofile>\n";
}


int main(int argc, char ** argv) {

  char * progname = *argv;
  char * filename = "dico.xml"; //NULL;

  bool validate = false, verbose = false;

  progress_timer t;

  set_unexpected(my_unexpected);

  argv++, argc--;

  while (argc) {

    if (**argv == '-') {

      string arg = *argv;

      if (arg == "-validate") {
        validate = true;
      } else if (arg == "-verbose") {
        verbose = true;
      } else if (arg == "-h" || arg == "-help" || arg == "-?") {
        usage(progname);
        return 0;
      } else {
        cerr << "unknow option : " << *argv << endl;
        exit(1);
      }
    } else { filename = *argv; }
    argv++, argc--;
  }

  if (filename == NULL) {
    cerr << "no filename specified\n";
    exit(1);
  }


  LIBXML_TEST_VERSION;
  
  xml_status xmlstatus;

  int nbentries = 0;

  try {

    xmlTextReaderPtr reader = xmlReaderForFile(filename, NULL, 0); // XML_PARSE_DTD_VALID ...

    if (! reader) {
      cerr << "unable to open '" << filename << "'\n";
      exit(1);
    }

    if (validate) {
      xmlTextReaderSetParserProp(reader, XML_PARSER_VALIDATE, 1);
    }

    xmlTextReaderSetErrorHandler(reader, xml_reader_default_error_handler, & xmlstatus);

    int ret; 
    while (((ret = xmlTextReaderRead(reader)) == 1)) {

      if ((xmlTextReaderNodeType(reader) == XML_READER_TYPE_ELEMENT)
          && (xmlStrcmp(xmlTextReaderConstName(reader), (const xmlChar *) DIC_ENTRY) == 0)) {


        xmlNodePtr cur = xmlTextReaderExpand(reader);

        xmlcheck(xmlstatus);

        dic_entry entry(cur);

        if (verbose) { cout << entry << '\n'; }
        

        nbentries++;

        if ((nbentries % 1000) == 0) {
          cerr << '.';
          if ((nbentries % 10000) == 0) { cerr << ' '; }
        }

        xmlTextReaderNext(reader);
      }

      xmlcheck(xmlstatus);
    }

    xmlcheck(xmlstatus);
    xmlFreeTextReader(reader);

    if ((ret == -1)) {
      cerr << "parsing error with '" << filename << "'\n"; 
      cerr << '\n' << nbentries << " entries parsed\n";
      exit(1);
    }

  } catch (xml_parse_error & error) {
    cerr << "XML parsing error : " << error.what() << '\n';
    exit(1);
  } catch (exception & e) {
    cerr << "caught an exception : " << e.what() << '\n';
    exit(1);
  } catch (...) {
    cerr << "caught an OVNI?\n"; 
    exit(1);
  }
  

  cerr << '\n' << nbentries << " entries parsed\n";

  return 0;
}

