#ifndef _ULOOKUP_H_
#define _ULOOKUP_H_

#include <set>
#include <string>

#include <outilex/dico.h>
#include <outilex/dic_lex_entry.h>

#define MATCH_EXACT        0
#define MATCH_IGNORE_MAJ   1
#define MATCH_IGNORE_CASE  3 /* IGNORE_CASE => IGNORE_MAJ */
#define MATCH_IGNORE_MARKS 4


int ulookup(const dico::position & pos, int lookup_type, const std::string & form,
             std::set<dic_lex_entry> & res, std::set<dico::position> & left);

int ulookup(const dico & dic, int lookup_type, const std::string & form,
             std::set<dic_lex_entry> & res, std::set<dico::position> & left);

int ulookup(const dico & dic, int lookup_type, const std::string & form,
             std::set<dic_lex_entry> & res);

#if 0
template<typename PosOutIterator>
int uloukup(const dico::position & pos, int lookup_type, const std::string & form,
             std::set<dic_lex_entry> & res, PosOutIterator it_left) {

  std::set<dico::position> left;
  bool ok = ulookup(pos, lookup_type, form, res, left);

  std::copy(left.begin(), left.end(), it_left);

  return ok;
}
#endif

template<typename LexOutIterator, typename PosOutIterator>
int ulookup(const dico::position & pos, int lookup_type, const std::string & form,
                LexOutIterator it_res, PosOutIterator it_left) {

  std::set<dic_lex_entry> res;
  std::set<dico::position> left;
  int nb = ulookup(pos, lookup_type, form, res, left);

  std::copy(res.begin(), res.end(), it_res);
  std::copy(left.begin(), left.end(), it_left);

  return nb;
}

#endif

