#ifndef _LEX_ENTRY_H_
#define _LEX_ENTRY_H_

#include <iosfwd>
#include <string>
#include <map>

#include <outilex/xmlWriter.h>

struct dic_lex_entry {

  std::string form;
  std::string lemma;
  std::string POS;
  std::map<std::string, std::string> feats;

  dic_lex_entry() : form(), lemma(), POS(), feats() {}
  dic_lex_entry(const std::string & f, const std::string & l, const std::string & fs)
    : form(f), lemma(l), POS(), feats() { read_pos_n_feats(fs); }

  void read_pos_n_feats(const std::string & f);

  void dump_text(std::ostream & os) const;

  void write_XML(xmlwriter & writer) const;  

  friend bool operator<(const dic_lex_entry & a, const dic_lex_entry & b) {
    if (a.POS != b.POS) { return a.POS < b.POS; }
    if (a.feats != b.feats) { return a.feats < b.feats; }
    if (a.lemma != b.lemma) { return a.lemma < b.lemma; }
    return a.form < b.form;
  }
};

inline std::ostream & operator<<(std::ostream & os, const dic_lex_entry & e) {
  e.dump_text(os); return os;
}

#endif

