#ifndef _DIC_INDEXER_H_
#define _DIC_INDEXER_H_

#include <iostream>
#include <fstream>
#include <string>

#include <boost/filesystem/path.hpp>

#include <unicode/utypes.h>

#include <outilex/dic_fsa2.h>

#include <outilex/dic_entry.h>
#include <outilex/lexico_hash_table.h>
#include <outilex/dic_entry_value.h>


class dic_indexer {

  typedef dic_fsa2<dic_entry_value, UChar> FSA;

  FSA fsa;
  lexico_hash_table<std::string> entries_feats; // donnons,donner.V+t+36DT:P1p -> V+t+synttable=36DT
  lexico_hash_table<std::string> inflex_feats;  //                             -> +tense=present+pers=1+number=p.3er

  void output_state(std::ostream & os, int qno) const;
  void output_values(std::ostream & os) const;
  void output_feats(std::ostream & os) const;
  void output_fsa(std::ostream & os) const;


public:

  dic_indexer() : fsa(), entries_feats(), inflex_feats() {}
  ~dic_indexer() {}

  void clear();
  int size() { return fsa.size(); }

  void add_entry(const dic_entry & e);
 
  /* minimize the index fsa */
  void minimize() { fsa.minimize(); } 
  
  // serialize indexed dic in path
  void write(const boost::filesystem::path & path) const;



  /* for debugging purpose */

  friend struct dump_entries;
  void dump(std::ostream & os) const;

  void dump_dot(const char * fname) const { fsa.dump_dot(fname); }
};


#endif

