#ifndef _ENTRY_VALUE_H_
#define _ENTRY_VALUE_H_


struct dic_entry_value {

  int idx;    // lexical entry
  int feats;  // inflexionnal features

  dic_entry_value(int e, int f) : idx(e), feats(f) {}

  bool operator<(const dic_entry_value & b) const {
    if (idx != b.idx) { return idx < b.idx; }
    return feats < b.feats; 
  }
  bool operator==(const dic_entry_value & b) const {
    return idx == b.idx && feats == b.feats;
  }
};


#endif

