#ifndef _DIC_ENTRY_H_
#define _DIC_ENTRY_H_

#include <iostream>
#include <string>
#include <vector>
#include <libxml/tree.h>


extern const char * DIC_ENTRY;

struct inflected {

public:

  std::string form;
  std::string feats;

  inflected() : form(), feats() {}
  inflected(xmlNodePtr node);

  void dump(std::ostream & os) const;
};

inline std::ostream & operator<<(std::ostream & os, const inflected & inf) { 
  inf.dump(os); return os;
}


struct dic_entry {

public:
  std::string lemma;
  std::string pos;
  std::string feats;
  std::vector<inflected> inflecteds;

  dic_entry() : lemma(), pos(), feats(), inflecteds() {}
  dic_entry(xmlNodePtr node);

  void dump(std::ostream & os) const;
  void swap(dic_entry & e) {
    lemma.swap(e.lemma); pos.swap(e.pos); feats.swap(e.feats);
    inflecteds.swap(e.inflecteds);
  }
};

inline std::ostream & operator<<(std::ostream & os, const dic_entry & entry) {
  entry.dump(os);
  return os;
}


#endif

