#include <iostream>
#include <vector>
#include <string>
#include <stdexcept>

#include <outilex/stringtok.h>
#include <outilex/dic_lex_entry.h>

using namespace std;

void dic_lex_entry::read_pos_n_feats(const string & fs) {

  vector<string> v;
  stringtok(fs, "+", back_inserter(v));

  if (v.empty()) { throw runtime_error("dic_lex_entry: read_pos_n_feats bad params : " + fs); }

  POS = v[0];

  for (int i = 1; i < v.size(); ++i) {
  
    string::size_type equal = v[i].find('=');
    
    if (equal == string::npos) {
      feats[v[i]] = "true";
    } else {
      feats[v[i].substr(0, equal)] = v[i].substr(equal + 1);
    }
  }
}


void dic_lex_entry::write_XML(xmlwriter & writer) const {

  writer.start_element("lex_entry");

  writer.write_element("form", form);

  if (! lemma.empty()) { writer.write_element("lemma", lemma); }
 
  writer.start_element("pos");
  writer.write_attribute("name", POS);
  writer.end_element();

  for (map<string, string>::const_iterator it = feats.begin(); it != feats.end(); ++it) {
    writer.start_element("feat");
    writer.write_attribute("name", it->first);
    writer.write_attribute("value", it->second);
    writer.end_element();
  }
  writer.end_element(); // lex_entry
}

#if 0
void dic_lex_entry::dump_XML(ostream & os) const {

  os << "<lex_entry><form>" << form << "</form>";
  if (! lemma.empty()) { os << "<lemma>" << lemma << "</lemma>"; }
  os << "<pos name='" << POS << "'/>";

  for (map<string, string>::const_iterator it = feats.begin(); it != feats.end(); ++it) {
    os << "<feat name='" << it->first << "' value='" << it->second << "'/>";
  }
  os << "</lex_entry>";
}
#endif

void dic_lex_entry::dump_text(std::ostream & os) const {
  os << form << ',' << lemma << '.' << POS;
  for (std::map<std::string, std::string>::const_iterator it = feats.begin();
       it != feats.end(); ++it) {
    os << '+' << it->first << '=' << it->second;
  }
}

