#include <iostream>
#include <string>
#include <iterator>
#include <libxml/xmlreader.h>

#include <outilex/xml.h>
#include <outilex/dic_entry.h>

using namespace std;

const char * DIC_ENTRY = "entry";


inflected::inflected(xmlNodePtr node) : form(), feats() {

  xmlChar * text;

  node = node->xmlChildrenNode;

  while (node != NULL) {

    if (xmlStrcmp(node->name, (const xmlChar *) "form") == 0) {

      text  = xmlNodeGetContent(node);
      form = (char *) text;
      xmlFree(text);

    } else if (xmlStrcmp(node->name, (const xmlChar *) "feat") == 0) {

      feats += '+';
      text = xmlGetProp(node, (const xmlChar *) "name");
      if (text == NULL) { throw runtime_error("inflected:: no feat name"); }
      feats += (char *) text;
      xmlFree(text);

      feats += '=';
      text = xmlGetProp(node, (const xmlChar *) "value");
      if (text == NULL) { throw runtime_error("inflected:: no feat value"); }
      feats += (char *) text;
      xmlFree(text);
    }

    node = node->next;
  }
}

void inflected::dump(std::ostream & os) const {
  os << "[inf:" << form << "," << feats << "]";
}



dic_entry::dic_entry(xmlNodePtr node) : lemma(), pos(), feats(), inflecteds() {

  xmlChar * text;

  node = node->xmlChildrenNode;

  while (node != NULL) {

    if (xmlStrcmp(node->name, (const xmlChar *) "lemma") == 0) {

      text  = xmlNodeGetContent(node);
      lemma = (char *) text;
      xmlFree(text);

    } else if (xmlStrcmp(node->name, (const xmlChar *) "pos") == 0) {

      text = xmlGetProp(node, (const xmlChar *) "name");
      pos = (char *) text;
      xmlFree(text);

    } else if (xmlStrcmp(node->name, (const xmlChar *) "feat") == 0) {

      feats += '+';
      text = xmlGetProp(node, (const xmlChar *) "name");
      feats += (char *) text;
      xmlFree(text);

      feats += '=';
      text = xmlGetProp(node, (const xmlChar *) "value");
      if (! text) { throw xml_parse_error("dic_entry: no feat value"); }
      feats += (char *) text;
      xmlFree(text);

    } else if (xmlStrcmp(node->name, (const xmlChar *) "inflected") == 0) {

      inflecteds.push_back(inflected(node));
    }

    node = node->next;
  }
}

void dic_entry::dump(ostream & os) const {
  os << "<dic_entry:" << lemma << "." << pos << feats;
  os << '{';
  copy(inflecteds.begin(), inflecteds.end(), ostream_iterator<inflected>(os, ","));
  os << '}';
}

