#include <iostream>

#include <outilex/dico.h>
#include <outilex/ulookup.h>

using namespace std;

void usage(string & progname, ostream & os = cerr) {
  os << "usage: " << progname << " [-imaj][-imark][-icase] -dic <diconame> [ req1 [req2 ...]]\n";
}

int main(int argc, char ** argv) {

  string progname = *argv;
  string diconame;
  int lookup_type = MATCH_EXACT;

  vector<string> reqs;

  argv++, argc--;

  if (argc == 0) { usage(progname); return 1; }

  while (argc > 0) {
  
    string arg = *argv;

    if (arg[0] == '-') {
      
      if (arg == "-dic") {
      
        argv++, argc--;
      
        if (argc < 1) { cerr << "bad args\n"; abort(); }

        diconame = *argv;

      } else if (arg == "-icase") {

        lookup_type |= MATCH_IGNORE_CASE;

      } else if (arg == "-imark") {

        lookup_type |= MATCH_IGNORE_MARKS;

      } else if (arg == "-imaj") {

        lookup_type |= MATCH_IGNORE_MAJ;
      
      } else if (arg == "-h" || arg == "-help" || arg == "-?") {
      
        usage(progname, cout);
        return 0;
      }

    } else { // req in cmdline
      reqs.push_back(arg);
    }

    argv++, argc--;
  }
  
  if (diconame.empty()) {
    cerr << "error: no dic name specified\n";
    exit(1);
  }

  dico dic(diconame);
  cerr << diconame << " loaded.\n";

  set<dic_lex_entry> res;

  cout << '\n';

  if (! reqs.empty()) { // requets in command line
    for (int i = 0; i < reqs.size(); ++i) {
      cout << reqs[i] << ": ";
      cout << '\n';
      if (ulookup(dic, lookup_type, reqs[i], res)) {
        for (set<dic_lex_entry>::iterator it = res.begin(); it != res.end(); ++it) {
          cout << "-> " << *it << '\n';
        }
        cout << '\n';
      } else {
        cout << "not found\n\n";
      }
    }
    return 0;
  }

  
  string w;

  cout << "? ";
  while (cin >> w) {
    res.clear();
    if (ulookup(dic, lookup_type, w, res)) {
      copy(res.begin(), res.end(), ostream_iterator<dic_lex_entry>(cout, "\n"));
    } else {
      cout << w << " not found.\n";
    }
    cout << "? ";
  }
}

