#include <iostream>
#include <sstream>

#include <libxml/xmlreader.h>

#include <outilex/xml.h>

using namespace std;

void xml_reader_default_error_handler(void * s, const char * msg, xmlParserSeverities severity,
                                      xmlTextReaderLocatorPtr locator) {
  
  xml_status * status = static_cast<xml_status *>(s);

  ostringstream head;

  head << (char *) xmlTextReaderLocatorBaseURI(locator) <<
    ':' << xmlTextReaderLocatorLineNumber(locator) << ": ";
  status->error_msg = head.str();

  switch (severity) {

  case XML_PARSER_SEVERITY_VALIDITY_WARNING:
    status->error_msg += "validity warning: ";
    break;
   
  case XML_PARSER_SEVERITY_WARNING:
    status->error_msg += "parsing warning: ";
    break;

  case XML_PARSER_SEVERITY_VALIDITY_ERROR:
    status->error_msg += "validity error: ";
    break;

  case XML_PARSER_SEVERITY_ERROR:
    status->error_msg += "parsing error: ";
    break;
  }

  status->severity = severity;
  status->error_msg += msg;

  cerr << status->error_msg << '\n';
}

void xmlcheck(const xml_status & status) {
  if (status.severity == XML_PARSER_SEVERITY_VALIDITY_ERROR || status.severity == XML_PARSER_SEVERITY_ERROR) {
    throw xml_parse_error(status.error_msg);
  }
}


namespace {

int ostream_write(void * ctxt, const char * buffer, int len) {
  streambuf * sbuf = static_cast<streambuf *>(ctxt);
  return sbuf->sputn(buffer, len);
}

int ostream_sync(void * ctxt) {
  streambuf * sbuf = static_cast<streambuf *>(ctxt);
  return sbuf->pubsync();
}

} // anonymous namespace


xmlOutputBufferPtr create_streambuf_xmlOutputBuffer(streambuf * sbuf) {
  return xmlOutputBufferCreateIO(& ostream_write, & ostream_sync,
                                 static_cast<void *>(sbuf), NULL);
}


xmlChar * xmlGetConstProp(xmlNode * node, const xmlChar * attrname) {
  static xmlChar * data = NULL;
  if (data) xmlFree(data);
  data = xmlGetProp(node, attrname);
  return data;
}
