#ifndef _XMLREADER_H_
#define _XMLREADER_H_

#include <boost/filesystem/path.hpp>
#include <string>
#include <stdexcept>

#include <outilex/xml.h>
#include <libxml/xmlreader.h>


class xmlreader {

public:

  inline xmlreader() : reader(NULL), status() {}

  inline xmlreader(const boost::filesystem::path & path) : reader(NULL), status() { open(path); }
 
  inline ~xmlreader() { close(); }

  inline void open(const boost::filesystem::path &path) {
    close();
    std::string fname = path.native_file_string();
    reader = xmlReaderForFile(fname.c_str(), NULL, 0);
    if (! reader) { throw std::runtime_error("xmlreader: cannot open " + fname); }
    xmlTextReaderSetErrorHandler(reader, xml_reader_default_error_handler, & status);
  }

  void close() {
    if (reader) {
      xmlFreeTextReader(reader);
      status.clear();
      reader = NULL;
    }
  }

  inline void check() { xmlcheck(status); }

  inline operator bool() const { return reader && status.severity == 0; }
  //bool operator!() const { return ! *this; }


  inline int get_parser_prop(int prop) { return xmlTextReaderGetParserProp(reader, prop); }

  inline int set_parser_prop(int prop, bool active) {
    return xmlTextReaderSetParserProp(reader, prop, active);
  }
  
  inline int read_state() { return xmlTextReaderReadState(reader); }
  inline int node_type() { return xmlTextReaderNodeType(reader); }

  inline int read() { return xmlTextReaderRead(reader); }
  inline int next() { return xmlTextReaderNext(reader); }

  inline xmlNodePtr expand() { return xmlTextReaderExpand(reader); }

  inline int is_valid() { return xmlTextReaderIsValid(reader); }	

  inline int is_empty_element() { return xmlTextReaderIsEmptyElement(reader); }

  inline char * name() { return (char *) xmlTextReaderName(reader); }

  inline  char * local_name() { return (char *) xmlTextReaderLocalName(reader); }
  inline const char * const_name() { return (const char *) xmlTextReaderConstName(reader); }

  inline int has_value() { return xmlTextReaderHasValue(reader); }

  inline char * const_value() { return (char *) xmlTextReaderConstValue(reader); }

  inline int depth() { return xmlTextReaderDepth(reader); }


  inline char * value() { return (char *) xmlTextReaderValue(reader); }
  inline char * read_string() { return (char *) xmlTextReaderReadString(reader); }



  inline int move_to_element() { return xmlTextReaderMoveToElement(reader); }

  /* attributes */

  inline int has_attributes() { return xmlTextReaderHasAttributes(reader); }
  inline int attribute_count() { return xmlTextReaderAttributeCount(reader); }

  inline int move_to_attribute(const std::string & name) {
    return xmlTextReaderMoveToAttribute(reader, (xmlChar *) name.c_str());
  }

  inline int move_to_attribute_no(int no) { return xmlTextReaderMoveToAttributeNo(reader, no); }

  inline int move_to_first_attribute() { return xmlTextReaderMoveToFirstAttribute(reader); }

  inline int move_to_next_attribute() { return xmlTextReaderMoveToNextAttribute(reader); }

  inline char * get_attribute(const std::string & name) {
    return (char *) xmlTextReaderGetAttribute(reader, (xmlChar *) name.c_str());
  }

  inline char * get_attribute_no(int no) {
    return (char *) xmlTextReaderGetAttributeNo(reader, no);
  }


protected:
  xmlTextReaderPtr reader;
  xml_status status;
};

#endif
