#ifndef _XML_H_
#define _XML_H_

#include <iostream>
#include <stdexcept>
#include <string>

#include <libxml/tree.h>
#include <libxml/xmlreader.h>


/* libxml error handling.
 * we have to make exception throwing asynchronous
 * because we cannot throw them from libxml callback...
 */


class xml_parse_error : public std::runtime_error {
public:
  xml_parse_error(const std::string & msg) : runtime_error(msg) {}
};

struct xml_status {
  int severity;
  std::string error_msg;
  inline xml_status() : severity(0), error_msg() {} 
  inline void clear() { severity = 0; }
};


void xml_reader_default_error_handler(void * status, const char * msg, xmlParserSeverities severity,
                                      xmlTextReaderLocatorPtr locator);

/* throw xml_parse_error in case of an parsing/validation error in libxml routines
 */
void xmlcheck(const xml_status & status);


/* libxml helpers functions */

struct XML_Dumper {

  std::ostream & os;

  XML_Dumper(std::ostream & os_) : os(os_) {}

  template<typename Type>
  void operator()(const Type & a) { a.dump_XML(os); }
};


xmlChar * xmlGetConstProp(xmlNode * node, const xmlChar * attrname);


inline char * xmlGetProp(xmlNodePtr node, const char * attrname) {
  return (char *) xmlGetProp(node, (const xmlChar *) attrname);
}

inline char * xmlGetConstProp(xmlNode * node, const char * attrname) {
  return (char *) xmlGetConstProp(node, (const xmlChar *) attrname);
}

inline int xmlStrcmp(const char * a, const xmlChar * b) {
  return xmlStrcmp((const xmlChar *) a, b);
}

inline int xmlStrcmp(const xmlChar * a, const char * b) {
  return xmlStrcmp(a, (const xmlChar *) b);
}

inline int xmlStrcmp(const char * a, const char * b) {
  return xmlStrcmp((const xmlChar *) a, (const xmlChar *) b);
}


inline char * xmlTextReaderGetAttribute(xmlTextReaderPtr reader, const char * attrname) {
  return (char *) xmlTextReaderGetAttribute(reader, (const xmlChar *) attrname);
}


/* xmlOutputBuffer/iostream helpers */

xmlOutputBufferPtr create_streambuf_xmlOutputBuffer(std::streambuf * sbuf);

inline xmlOutputBufferPtr create_ostream_xmlOutputBuffer(std::ostream & os) {
  return create_streambuf_xmlOutputBuffer(os.rdbuf());
}

//#include <outilex/xmlReader.h>
#include <outilex/xmlWriter.h>
#endif
