#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "utilities.h"


int util_n_free = 0;
int util_n_malloc = 0;

void* util_malloc(int n){
  util_n_malloc++;
  return (void *)malloc(n);
}

void util_pfree(void *ptr){
  if(ptr == NULL) return;
  util_n_free++;
  free(ptr);
  ptr = NULL;
}

int util_print_n_malloc(){
  printf("util_malloc=%d\n",util_n_malloc);
  return util_n_malloc;
}

int util_print_n_free(){
  printf("util_free=%d\n",util_n_free);
  return util_n_free;
}

void util_get_path(char long_filename[],char path[]){
  int i;

  strcpy(path,long_filename);
  for(i = strlen(path) - 1 ; (path[i] != '/') && (i >= 0) ; i--);
  path[i + 1] = 0;
  
}

void util_get_filename(char long_filename[],char filename[]){
  int i,j;

  for(i = strlen(long_filename) - 1 ; (long_filename[i] != '/') && (i >= 0) ; i--);
  i++;
  j = 0;
  while(long_filename[i] != 0){
    filename[j] = long_filename[i];
    j++;
    i++;
  }
  filename[j] = 0;
}

void util_substr(char s[],int start,int end,char sub[]){
  int i,j;
  j = 0;
  for(i = start ; i < end ; i++){
    sub[j] = s[i];
    j++;
  }
  sub[j] = 0;
}

char *util_alloc_string(char s[]){
  char *res = (char*)util_malloc((strlen(s) + 1) * sizeof(char));
  if(res == NULL) return NULL;
  strcpy(res,s);
  return res;
}

void util_free_string(char *s){
  util_pfree(s);
}

int util_or(int x,int y){
  return (x|y);
}

int util_and(int x,int y){
  return (x&y);
}

int util_not(int x){
  return (!x);
}

// the  bit marked 1 in x is removed in y
int util_bit_removal(int x, int y){
  if(x&y){
    if(x > y) return(x - y);
    return (y - x);
  }
  return y;
}

int util_min(int x,int y){
  if(x < y) return x;
  return y;
}


int util_max(int x,int y){
  if(x > y) return x;
  return y;
}


void util_error(char *function,char *message){
  fprintf(stderr,"%s: %s\n",function,message);
  exit(1);
}

void util_warning(char *function,char *message){
  fprintf(stderr,"WARNING::: %s: %s\n",function,message);
}
