#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <malloc.h>
#include "ustring.h"
#include "utilities.h"
#include <unistd.h>

int ustring_n_free = 0;
int ustring_n_malloc = 0;

void* ustring_malloc(int n){
  ustring_n_malloc++;
  return (void *)malloc(n);
}

void ustring_pfree(void *ptr){
  if(ptr == NULL) return;
  ustring_n_free++;
  free(ptr);
  ptr = NULL;
}

int ustring_print_n_malloc(){
  printf("ustring_malloc=%d\n",ustring_n_malloc);
  return ustring_n_malloc;
}

int ustring_print_n_free(){
  printf("ustring_free=%d\n",ustring_n_free);
  return ustring_n_free;
}


//return 0 if u and v are equal
//return 1 else

int ustring_cmp(Ustring u,Ustring v){
  int i,lu,lv;

  lu = ustring_length(u);
  lv = ustring_length(v);
  if(lu != lv) return 1;
  for(i = 0 ; i < lu ; i++){
    if(u[i] != v[i]) return 1;
  }

  return 0;
}

int ustring_length(Ustring ustr){
  int i = 0;
  if(ustr == NULL) return 0;
  while(ustr[i] != 0){
    i++;
  }
  /*
  while((ustr[i] != 0) && (i < USTRING_LENGTH_MAX)){
    i++;
  }
  if(i == USTRING_LENGTH_MAX) return -1;
  */
  return i;
}


Ustring ustring_allocation(Uchar arr[]){
  Ustring ustr;
  int i,length;
  
  length = ustring_length(arr);
  if(length < 0) return NULL;
  ustr = (Ustring)ustring_malloc((length + 1) * sizeof(Uchar));
  for(i = 0 ; i < length ; i++){
    ustr[i] = arr[i];
  }
  ustr[i] = 0;
  return ustr;
}

Ustring ustring_allocation2(Tab_i arr){
  Ustring ustr;
  int i,length;
  
  length = tab_i_get_n_elements(arr);
  if(length <= 0) return NULL;
  
  ustr = (Ustring)ustring_malloc((length + 1) * sizeof(Uchar));
  for(i = 0 ; i < length ; i++){
    ustr[i] = tab_i_get_value(arr,i);
  }
  ustr[i] = 0;
  return ustr;
}


Ustring ustring_copy(Ustring source){
  return ustring_allocation(source);
}

void ustring_free(Ustring ustr){
  if(ustr != NULL) ustring_pfree(ustr);
}

void ustring_free_string(char* s){
  if(s != NULL) ustring_pfree(s);
}

char *ustring_alloc_string(char s[]){
  char *temp = (char *)ustring_malloc((strlen(s) + 1)*sizeof(char));
  int i = 0;

  if(temp == NULL) return NULL;
  
  while(s[i] != 0){
    temp[i] = s[i];
    i++;
  }
  temp[i] = 0;
  return temp;
}


void ustring_print_array(Ustring u[]){
  int i;
  printf("**");
  for(i = 0 ; u[i] != NULL ; i++){
    ustring_print(u[i]);
    printf("**");
  }
  printf("\n");
}

void ustring_print(Ustring ustr, FILE * f){

  int i;
  if(ustr == NULL) {
    fprintf(f, "-- NULL USTRING --");
    return;
  }
  for(i = 0 ; ustr[i] != 0 ; i++){
    putc(ustr[i], f);
  }
}

void ustring_println(Ustring ustr, FILE *f){
  ustring_print(ustr, f);
  fprintf(f, "\n");
}

void ustring_println_codes(Ustring ustr){
  int i;
  if(ustr == NULL) {
      printf("-- NULL USTRING --\n");
      return;
  }
  for(i = 0 ; ustr[i] != 0 ; i++){
    printf("%d;",ustr[i]);
  }
  printf("\n");
}

void ustring_println2(Ustring u){
  ustring_println_codes(u);
}

// read a uchar depending on file format
// option = 0 unicode format (char = 2 bytes)
// option = 1 ascii format (char = 1 byte)
// assuming that we are on linux

Uchar ustring_read_uchar(FILE *f,int option){
  int c;
  Uchar uc = 0;
  c = fgetc(f);
  //printf("(1,%c)",(char)c);
  if(feof(f)) return -1;
  if(option == 1) return c;
  uc = c;
  c = fgetc(f);
  //printf("(2,%c)",(char)c);
  if(feof(f)) return -1;
  //  if(c == EOF) return EOF;
   c >>= (16*sizeof(char));
   uc += c;
  return uc;
}


Ustring ustring_get_line(FILE *f, int option){
  Tab_i temp = NULL;
  Uchar c;
  Ustring ustr = NULL;
  int i = 0,end_line = 0,end_file = 0;

  while(!end_line){
    c = ustring_read_uchar(f,option);
    tab_i_assign_value(&temp,i,c);
    //    printf("=%d=%c=\n",tab_i_get_value(temp,i),(char)tab_i_get_value(temp,i));
    if(c == 10) end_line = 1;
    if(c == -1){ 
      end_line = 1;
      end_file = 1;
    }
    i++;
  }
  if(end_file){
    tab_i_free(&temp);
    return NULL;
  }

  if(tab_i_get_value(temp,i - 2) != 13){
    tab_i_assign_value(&temp,i - 1,0);
  }
  else{
    tab_i_assign_value(&temp,i - 2,0); // enchainement caracteres (13)(10) sous linux
  }
  
  //ustring_print(temp);printf("------\n");
  ustr = ustring_allocation2(temp);
  tab_i_free(&temp);
  // ustring_print(ustr);printf("------\n");
  return ustr;
}

int ustring_to_int(Ustring ustr){
  int i;
  int res = 0;
  if(ustr == NULL) return 0;
  for(i = 0 ; ustr[i] != 0 ; i++){
    if(!isdigit((char)ustr[i])) return res;
    res *= 10;
    res += ustr[i] - '0';
  }
  return res;
}

double ustring_to_decimal(Ustring ustr){
  int i,n;
  double res = 0.0;
  n = ustring_length(ustr);
  if(ustr == NULL) return 0.0;
  for(i = n-1 ; i >= 0 ; i--){
    if(isdigit((char)ustr[i])){
      res *= .1;
      res += (double)(ustr[i] - '0');
    }
  }
  res *= 0.1;
  return res;
}

double ustring_to_double(Ustring ustr){
  double res;
  Tab_u t;
  Ustring integer,decimal;
  t = ustring_split('.',ustr);
  integer = tab_u_get_value(t,0);
  decimal = tab_u_get_value(t,1);
  res = (double)ustring_to_int(integer)+ustring_to_decimal(decimal);
  tab_u_free(&t);
  return res;
}

int ustring_get_next_int(Ustring u,int *pos){
  int j = 0,sign = 1;
  Uchar temp[USTRING_LENGTH_MAX];

  while(!isdigit((char)u[*pos]) && (u[*pos] != '-') && (u[*pos] != 0)){
    (*pos)++;
  }
  if(u[*pos] == 0) return 0;
  if(u[*pos] == '-'){
    sign = -1;
    (*pos)++;
  }
  if(!isdigit((char)u[*pos])) return 0;
  while(isdigit((char)u[*pos])){
    temp[j] = u[*pos];
    j++;
    (*pos)++;
  }
  temp[j] = 0;
  return sign * ustring_to_int(temp);
}


char *ustring_to_string(Ustring u){
  int i;
  char *s = (char *)ustring_malloc((ustring_length(u) + 1)* sizeof(char));
  if(s == NULL) return NULL;
  for(i = 0 ; u[i] != 0 ; i++){
    s[i] = (char)u[i];
  }
  s[i] = 0;
  return s;
}

Ustring ustring_from_string(char s[]){
  int i;
  Ustring u = (Ustring)ustring_malloc((strlen(s) + 1)* sizeof(Uchar));
  if(u == NULL) return NULL;
  for(i = 0 ; s[i] != 0 ; i++){
    u[i] = (Uchar)s[i];
  }
  u[i] = 0;
  return u;
}

int ustring_contains(Ustring u,Uchar c){
  int i, length = ustring_length(u);
  if(u == NULL) return 0;
  for(i = 0 ; i < length ;i++){
    if(u[i] == c) return 1;
  }
  return 0;
}


int ustring_find(Ustring str, Uchar c){

  if (str == NULL) { return -1; }

  Uchar * p = str;
  while (*p) {
    if (*p == c) { return p - str; }
    ++p;
  }
  return -1;
}


int ustring_find_last(Ustring u,Uchar c){
  int i, length = ustring_length(u);
  if(u == NULL) return -1;
  for(i = length - 1 ; i >= 0 ;i--){
    if(u[i] == c) return i;
  }
  return -1;
}



Uchar ustring_get_uchar(Ustring u,int i){

  if(u == NULL) return -1;
  if(i >= ustring_length(u)) return -1;
  return u[i];
}


Ustring ustring_get_substr(Ustring u,int first,int last){
  Uchar s[USTRING_LENGTH_MAX];
  int i;
  if(last - first >= USTRING_LENGTH_MAX) return NULL;

  for(i = first ; i < last ; i++){
    s[i-first] = u[i];
  }
  s[last-first] = 0;
  return ustring_allocation(s);
}

Ustring ustring_get_substr2(Tab_i t,int first,int last){
  Uchar s[USTRING_LENGTH_MAX];
  int i;

  if(last - first >= USTRING_LENGTH_MAX) return NULL; 

  for(i = first ; i < last ; i++){
    s[i-first] = tab_i_get_value(t,i);
  }
  s[last-first] = 0;
  return ustring_allocation(s);
}



//TODO DESPECIALISATION
int ustring_count_backslashes(Ustring u,int end){
  int cnt = 0,i = end;
  while((i >= 0) && (u[i] == '\\')){
    cnt++;
    i--;
  }
  return cnt;
}


int ustring_compare_uchars_with_despecialization(Uchar c,int index,Ustring u){
  int n = ustring_length(u);
  if(index >= n) return 0;
  n = ustring_count_backslashes(u,index - 1);
  if(n%2 == 1) return 0;
  return(u[index]==c);
}

Tab_u ustring_split(Uchar c,Ustring u){

  int start,i = 0,j = 0;
  Tab_u res = NULL;
  Ustring v;
  
  if(u == NULL) return NULL;
  start = 0;
  while (u[i] != 0){
    v = NULL;
    if(ustring_compare_uchars_with_despecialization(c,i,u)){
      v = ustring_get_substr(u,start,i);
      tab_u_assign_value(&res,j,v);
      ustring_free(v);
      start = i + 1;
      j++;
    }
    i++;
  }
  v = ustring_get_substr(u,start,i);
  tab_u_assign_value(&res,j,v);
  ustring_free(v);
  return res;
}

Tab_u ustring_split_in_order(Ustring s,Ustring u){
  int start,i = 0,j = 0;
  Tab_u res = NULL;
  Ustring v = NULL;
  
  if(u == NULL) return NULL;
  if(s == NULL) return NULL;
  start = 0;
  while(u[i] != 0){
    v = NULL;
    if(ustring_compare_uchars_with_despecialization(s[j],i,u)){
      v = ustring_get_substr(u,start,i);
      tab_u_assign_value(&res,j,v);
      ustring_free(v);
      start = i + 1;
      j++;
    }
    i++;
  }
  if(u[i] == s[j]){
    v = ustring_get_substr(u,start,i);
    tab_u_assign_value(&res,j,v);
    ustring_free(v);
    return res;
  }
  ustring_free(v);
  tab_u_free(&res);
  return NULL;
}

Ustring ustring_strcat(Ustring * start, Uchar c) {

  if (*start == NULL) {
    *start = (Ustring) malloc(2 * sizeof(Uchar));
    **start = c;
    *(*start+1) = 0;
    return *start;
  }

  int l = ustring_length(*start);
  *start = (Ustring) realloc(*start, (l + 2) * sizeof(Uchar));
  (*start)[l] = c;
  (*start)[l + 1] = 0;
  return *start;
}

Ustring ustring_strcat(Ustring *start,Ustring end){
  int l,i, l_start,l_end;
  if(*start == NULL){ 
    *start = ustring_allocation(end);
    return (*start);
  }
  l_start = ustring_length(*start);
  l_end = ustring_length(end);
  l = l_start + l_end + 1;
  *start = (Ustring)realloc(*start,l*sizeof(Uchar));
  
  for(i = 0 ; i < l_end ; i++){
    (*start)[i + l_start] = end[i];
  }
  (*start)[l-1] = 0;
  return (*start);
}

void ustring_invert(Ustring *u){
  Uchar temp[USTRING_LENGTH_MAX];
  int i = 0,n;
  
  n = ustring_length(*u);
  if(n >= USTRING_LENGTH_MAX - 1) util_error("ustring_invert","USTRING_LENGTH_MAX too small");
  for(i = 0 ; i < n ; i++){
    temp[n - i - 1] = (*u)[i];
  }
  temp[n] = 0;
  ustring_free(*u);
  *u = ustring_allocation(temp);
}


void ustring_append(Ustring *u,int c){
  int n = ustring_length(*u);
  
  if(n == 0){
    *u = (Uchar *)ustring_malloc(2*sizeof(Uchar)); 
  }
  else{
    *u = (Uchar *)realloc(*u,(n+2)*sizeof(Uchar)); 
  }
  (*u)[n] = c;
  (*u)[n+1] = 0;
}


Ustring ustring_from_list(Llist_i ll){
  Ustring u = NULL;
  struct ll_i_cell *ptr;
  if(ll == NULL) return NULL;
  ptr = ll->head;
  while(ptr != NULL){
    ustring_append(&u,ptr->value);
    ptr = ptr->next;
  }
  return u;
}



void ustring_write(FILE * f, Ustring str) {

  if (! str) { fputs("(null)", f); }

  while (*str) {
    putc((*str < 255) ? *str : '?', f);
    str++;
  }
}


int ustring_write(int fd,Ustring temp){

  int cnt = 0,i;
  char c;
  int size = ustring_length(temp);

  for(i = 0 ; i < size ; i++){
    c = (char) ustring_get_uchar(temp,i);
    cnt+= write(fd,&c,1);
  }
  if(cnt != size) util_error("ustring_write","problem for writing ustring in descriptor");

  return cnt;
}


void  ustring_write_starting_mark(FILE * f){
  fputc(0xff, f); fputc(0xfe, f);
}

void  ustring_write_starting_mark(int fd){
  char BOM[] = { 0xff, 0xfe };
  if (2 != write(fd,BOM,2)) util_error("ustring_write_starting_uchar","cannot put starting uchar");
}


void  ustring_write_breakline_uchar(FILE * f) {
  putc('\n', f); putc(0, f);
}

void  ustring_write_breakline_uchar(int fd){
  char NL[] = { '\n', 0 };
  if(2 != write(fd,NL,2)) util_error("ustring_write_starting_uchar","cannot put starting uchar");
}


void ustring_write_utf_16(FILE * f, Ustring str){

  if (! str) { return; }

  while (*str) {
    putc(*str & 0xff, f);
    putc((*str >> 8) & 0xff, f);
    ++str;
  }
}


void ustring_write_utf_16(int fd,Ustring temp){

  int i;
  char uc[2];
  int size = ustring_length(temp);

  for(i = 0 ; i < size ; i++){
    uc[0] = temp[i] & 0xff;
    uc[1] = (temp[i] >> 8) & 0xff;
    if( 2 != write(fd,uc,2)) util_error("ustring_write_utf_16","cannot write uchar");
  }
}

void ustring_writeln_utf_16(FILE * fd, Ustring temp){
  ustring_write_utf_16(fd,temp);
  ustring_write_breakline_uchar(fd);
}

void ustring_writeln_utf_16(int fd,Ustring temp){
  ustring_write_utf_16(fd,temp);
  ustring_write_breakline_uchar(fd);
}

void ustring_writeln_utf_16_from_string(FILE * fd, char* s){
  Ustring temp = ustring_from_string(s);
  ustring_write_utf_16(fd,temp);
  ustring_write_breakline_uchar(fd);
  ustring_free(temp);
}

void ustring_writeln_utf_16_from_string(int fd,char* s){
  Ustring temp = ustring_from_string(s);
  ustring_write_utf_16(fd,temp);
  ustring_write_breakline_uchar(fd);
  ustring_free(temp);
}

void ustring_write_utf_16_from_string(FILE * fd, char* s){
  Ustring temp = ustring_from_string(s);
  ustring_write_utf_16(fd,temp);
  ustring_free(temp);
}

void ustring_write_utf_16_from_string(int fd,char* s){
  Ustring temp = ustring_from_string(s);
  ustring_write_utf_16(fd,temp);
  ustring_free(temp);
}

Ustring ustring_get_function(Ustring u){
  Ustring v = NULL;
  int i,l = ustring_length(u),start_bracket = 0,end_bracket = 0;
  Uchar c;

  for(i = 0 ; i < l ; i++){
    c = ustring_get_uchar(u,i);
    if(c == (Uchar)'(' )start_bracket++;
    if(c == (Uchar)')') end_bracket++;
    if(!start_bracket){
      ustring_append(&v,c);
    }
    else{
      if(start_bracket == end_bracket) return v;
    }
  }
  ustring_free(v);
  return NULL;
}

