#include <stdio.h>
#include <malloc.h>
#include "tree2.h"
#include "ustring.h"
#include "utilities.h"

int tree2_n_free = 0;
int tree2_n_malloc = 0;

void* tree2_malloc(int n){
  tree2_n_malloc++;
  return (void *)malloc(n);
}

void tree2_pfree(void *ptr){
  if(ptr == NULL) return;
  tree2_n_free++;
  free(ptr);
  ptr = NULL;
}

int tree2_print_n_malloc(){
  printf("tree2_malloc=%d\n",tree2_n_malloc);
  return tree2_n_malloc;
}

int tree2_print_n_free(){
  printf("tree2_free=%d\n",tree2_n_free);
  return tree2_n_free;
}


struct tree2_node * tree2_create_node(int c){
  struct tree2_node *ptr = (struct tree2_node *)tree2_malloc(sizeof(struct tree2_node));
  if(ptr == NULL) util_error("tree2_create_node","creating tree node");
  ptr->nodes = NULL;
  ptr->previous = NULL;
  ptr->mark = -1;
  ptr->letter = c;
  return ptr;
}

struct tree2_cell_node *tree2_create_cell_node(struct tree2_node *n){
  struct tree2_cell_node *ptr = (struct tree2_cell_node *)tree2_malloc(sizeof(struct tree2_cell_node));
  if(ptr == NULL) util_error("tree2_create_cell_node","creating tree cell_node");
  ptr->n = n;
  ptr->next = NULL;
  return ptr;
}


struct tree2_node * tree2_letter_exists(struct tree2_node *n,int l){
  struct tree2_cell_node *ptr; 
  ptr = n->nodes;
  while(ptr != NULL){
    if((ptr->n != NULL) && (ptr->n->letter == l)) return ptr->n;
    ptr = ptr->next;
  }
  return NULL;
}

void tree2_insert_cell_node(List_tree2_nodes *l,struct tree2_node *n){
  struct tree2_cell_node *ptr = tree2_create_cell_node(n);
  ptr->next = *l;
  *l = ptr;
}


struct tree2_node * tree2_insert_letter(struct tree2_node *n,int l){
  struct tree2_node *ptr;
  if((ptr = tree2_letter_exists(n,l)) == NULL){
    ptr = tree2_create_node(l);
    ptr->previous = n;
    tree2_insert_cell_node(&(n->nodes),ptr);
  }
  return ptr;
}

struct tree2_node* tree2_insert_word(struct tree2_node **root,int *w,int mark){
  int i;
  struct tree2_node *ptr = *root;
  for(i = 0 ; i < ustring_length(w) ; i++){
    ptr = tree2_insert_letter(ptr,w[i]);
  }
  ptr->mark = mark;
  return ptr;
}

int tree2_word_exists(struct tree2_node *root,int *w){
  int i;
  struct tree2_node *ptr = root;

  for(i = 0 ; i < ustring_length(w) ; i++){
    if((ptr = tree2_letter_exists(ptr,w[i])) == NULL) return -1;
  }
  return ptr->mark;
}

struct tree2_node *tree2_init(){
  return tree2_create_node(0);
}


void tree2_free(struct tree2_node **n){
  struct tree2_cell_node *ptr = (*n)->nodes;
  struct tree2_cell_node *p;

  while(ptr != NULL){
    tree2_free(&(ptr->n));
    p = ptr;
    ptr = ptr->next;
    tree2_pfree(p);
  }  
  tree2_pfree(*n);
}

Ustring tree2_get_element(struct tree2_node *n){
  Uchar u[USTRING_LENGTH_MAX];
  Ustring s = NULL;
  struct tree2_node *ptr = n;
  int i = 0;

  while(ptr != NULL){
    if(i == USTRING_LENGTH_MAX - 1) util_error("tree2_get_element","USTRING_LENGTH_MAX too short");
    u[i]= ptr->letter;
    ptr = ptr->previous;
    i++;
  }
  u[i] = 0;
  s = ustring_allocation(u);
  ustring_invert(&s);
  return s;
}
