/// HEADER of a c module implementing a tree containing words (ustring)

#ifndef _h_tree
#define _h_tree

#include "llist_i.h"

//struture of a tree_node

struct tree_node{
  struct tree_cell_node * nodes;
  int mark;
  int letter;
};

// structure of a cell of a linked list of tree_nodes

struct tree_cell_node{
  struct tree_node *n; //pointer to a tree_node
  struct tree_cell_node *next; 
};

typedef struct tree_cell_node * List_tree_nodes;
typedef struct tree_node * Tree_node;

// FUNCTIONS

void tree_insert_word(struct tree_node **root,int *w,int mark);
int tree_word_exists(struct tree_node *root,int *w);
Llist_i tree_find_prefixed_elements(Tree_node root,int * prefix);
struct tree_node *tree_init();
int tree_print_n_malloc();
int tree_print_n_free();
void tree_pfree(void *ptr);
void* tree_malloc(int n);
void tree_free(struct tree_node **n);

#endif
