#include <stdio.h>
#include <malloc.h>
#include "tree.h"
#include "ustring.h"
#include "utilities.h"

int tree_n_free = 0;
int tree_n_malloc = 0;

void* tree_malloc(int n){
  tree_n_malloc++;
  return (void *)malloc(n);
}

void tree_pfree(void *ptr){
  if(ptr == NULL) return;
  tree_n_free++;
  free(ptr);
  ptr = NULL;
}

int tree_print_n_malloc(){
  printf("tree_malloc=%d\n",tree_n_malloc);
  return tree_n_malloc;
}

int tree_print_n_free(){
  printf("tree_free=%d\n",tree_n_free);
  return tree_n_free;
}


struct tree_node * tree_create_node(int c){
  struct tree_node *ptr = (struct tree_node *)tree_malloc(sizeof(struct tree_node));
  if(ptr == NULL) util_error("tree_create_node","creating tree node");
  ptr->nodes = NULL;
  ptr->mark = -1;
  ptr->letter = c;
  return ptr;
}

struct tree_cell_node *tree_create_cell_node(struct tree_node *n){
  struct tree_cell_node *ptr = (struct tree_cell_node *)tree_malloc(sizeof(struct tree_cell_node));
  if(ptr == NULL) util_error("tree_create_cell_node","creating tree cell_node");
  ptr->n = n;
  ptr->next = NULL;
  return ptr;
}


struct tree_node * tree_letter_exists(struct tree_node *n,int l){
  struct tree_cell_node *ptr; 
  ptr = n->nodes;
  while(ptr != NULL){
    if((ptr->n != NULL) && (ptr->n->letter == l)) return ptr->n;
    ptr = ptr->next;
  }
  return NULL;
}

void tree_insert_cell_node(List_tree_nodes *l,struct tree_node *n){
  struct tree_cell_node *ptr = tree_create_cell_node(n);
  ptr->next = *l;
  *l = ptr;
}


struct tree_node * tree_insert_letter(struct tree_node *n,int l){
  struct tree_node *ptr;
  if((ptr = tree_letter_exists(n,l)) == NULL){
    ptr = tree_create_node(l);
    tree_insert_cell_node(&(n->nodes),ptr);
  }
  return ptr;
}

void tree_insert_word(struct tree_node **root,int *w,int mark){
  int i;
  struct tree_node *ptr = *root;

  for(i = 0 ; i < ustring_length(w) ; i++){
    ptr = tree_insert_letter(ptr,w[i]);
  }
  ptr->mark = mark;
}

int tree_word_exists(struct tree_node *root,int *w){
  int i;
  struct tree_node *ptr = root;

  for(i = 0 ; i < ustring_length(w) ; i++){
    if((ptr = tree_letter_exists(ptr,w[i])) == NULL) return -1;
  }
  return ptr->mark;
}

struct tree_node *tree_init(){
  return tree_create_node(0);
}

Tree_node tree_prefix_exists(Tree_node root,Ustring prefix){
  struct tree_node *ptr = root;
  int i;

  for(i = 0 ; i < ustring_length(prefix) ; i++){
    if((ptr = tree_letter_exists(ptr,prefix[i])) == NULL) return NULL;
  }

  return ptr;
}

void tree_walk_rec(Tree_node node,Llist_i *list){
  struct tree_cell_node *ptr;

  if(node->mark != -1) ll_i_insert_at_tail(list,node->mark);
  ptr = node->nodes;
  while(ptr != NULL){
   if(ptr->n != NULL){
     tree_walk_rec(ptr->n,list);
   }  
   ptr = ptr->next;
  }
  
}


Llist_i tree_walk(Tree_node start_node){
 Llist_i list = NULL;
  if(start_node == NULL) return NULL;
  tree_walk_rec(start_node,&list);
 return list;
}

Llist_i tree_find_prefixed_elements(Tree_node root,Ustring prefix){
  Tree_node node;
  node = tree_prefix_exists(root,prefix);
  if(node == NULL) return NULL;
  return tree_walk(node);
}

void tree_free(struct tree_node **n){
  struct tree_cell_node *ptr = (*n)->nodes;
  struct tree_cell_node *p;

  while(ptr != NULL){
    tree_free(&(ptr->n));
    p = ptr;
    ptr = ptr->next;
    tree_pfree(p);
  }  
  tree_pfree(*n);
}
