#ifndef _h_tok 
#define _h_tok

#include "lexicon.h"
#include "tab_d.h"

#define TOK_WITH_FREQ 1
#define TOK_WITHOUT_FREQ 0

struct tokens{
  Lexicon lex;
  Tab_i freq;  
};

typedef struct tokens Tokens;

//functions

int tok_exists(Tokens tok,Ustring u);
char tok_add_element(Tokens *tok,Ustring u,char with_freq,int *index);
char tok_add_element_from_string(Tokens *tok,char *s,char with_freq,int *index);
Ustring tok_get_element(Tokens tok,int i);
void tok_init(Tokens *tok);
void tok_free(Tokens *tok);
void tok_print(Tokens tok);
void tok_println(Tokens tok);
Lexicon tok_get_lexicon(Tokens tok);
Tab_u tok_get_lexicon_tab(Tokens tok);
void tok_assign(Tokens *dest,Tokens src);
#endif
