#include "tokens.h"
#include "utilities.h"

Lexicon tok_get_lexicon(Tokens tok){
  return tok.lex;
}

Tab_u tok_get_lexicon_tab(Tokens tok){
  return lex_get_tab(tok.lex);
}

int tok_exists(Tokens tok,Ustring u){
  if(tok.lex == NULL) return -1;
  return lex_get_index(tok.lex,u);
}


// add a new token
// return if it is a real new token of not

char tok_add_element(Tokens *tok,Ustring u,char with_freq,int *index){
  char new;

  *index = lex_add_element2(&(tok->lex),u,&new);
  if(with_freq){
    if(new){
      tab_i_assign_value2(&(tok->freq),*index,0,0);
    }
    tab_i_assign_value2(&(tok->freq),*index,tab_i_get_value(tok->freq,*index) + 1,0);
  }
  else{
    tab_i_assign_value2(&(tok->freq),*index,0,0);
  }
  return new;
}

Ustring tok_get_element(Tokens tok,int i){  
  return lex_get_element(tok.lex,i);
}

void tok_init(Tokens *tok){
  Ustring u;
  int i;

  tok->lex = lex_init();
  tok->freq = NULL;
  u = ustring_from_string("<E>");
  tok_add_element(tok,u,TOK_WITHOUT_FREQ,&i);
  i++; //DO NOTHING
  ustring_free(u);
}


void tok_free(Tokens *tok){
  if(tok == NULL) return;
  lex_free(&(tok->lex));
  tab_i_free(&(tok->freq));
}


void tok_print(Tokens tok){
  lex_print(tok.lex);
}

void tok_println(Tokens tok){
  tok_print(tok);
}


void tok_assign(Tokens *dest,Tokens src){
  if(dest == NULL) util_error("tok_assign","dest should not be null");
  dest->lex = src.lex;
  dest->freq = src.freq;
}


char tok_add_element_from_string(Tokens *tok,char *s,char with_freq,int *index){
  char res;
  Ustring u = ustring_from_string(s);
  res = tok_add_element(tok,u,with_freq,index);
  ustring_free(u);
  return res;
}
