#ifndef _h_table
#define _h_table
#include <stdio.h>
#include "lexicon.h"
#include "tab2_i.h"

//table structure
#define TABLE_PLUS 1
#define TABLE_MINUS 0
#define TABLE_EPSILON 2
#define TABLE_TILDE   3

#define TABLE_ONE_ROW_HEADER 1
#define TABLE_TWO_ROW_HEADER 2

#define TABLE_NORMAL_PARAMETER   0 // resolve to <E> if '+' or ~, NULL if -, property value otherwise
#define TABLE_NOT_PARAMETER      1 // (!) resolve to <E> if '-' and NULL otherwise
#define TABLE_PREFIX_PARAMETER   2 // ($) prefix stuff
#define TABLE_ROWID_PARAMETER    3 // (%) resolve to entry's row number
#define TABLE_DEFAULT_PARAMETER  4 // (:) resolve to NULL if '-', otherwise to default value associated with property
#define TABLE_META_PARAMETRE 5 //for meta-paremeterized grammars only

struct table{
  int n_rows;
  int n_columns;
  Lexicon lex; //lexicon of the table; +: index 1 ; -: index 0 ; <E> : index 2 
  Tab2_i content;
  Lexicon header; // lexicon of the header
  Tab_i default_header; //default values for each column
};

typedef struct table* Table;

//functions

int table_print_n_free();
int table_print_n_malloc();
Table table_load(char *filename,char *configname,int encoding,int header_type);
void table_free(Table *tab);
Ustring table_get_value_with_indexes(Table tab,int row,int col);
Ustring table_get_value(Table tab,int row,Ustring col, bool warnifnotexist = true);
Ustring table_get_default_value(Table tab,Ustring col);
void table_print(Table tab);
int table_get_n_rows(Table tab);
int table_get_n_columns(Table tab);
Ustring table_resolve_parameter(Table tab,int row, Ustring parameter);
Ustring table_resolve_meta_parameter(Table tab,int row, Ustring parameter);
#endif
