#include <stdio.h>
#include <malloc.h>
#include "tab_u.h"

int tab_u_n_free = 0;
int tab_u_n_malloc = 0;

void* tab_u_malloc(int n){
  tab_u_n_malloc++;
  return (void *)malloc(n);
}

void tab_u_pfree(void *ptr){
  tab_u_n_free++;
  free(ptr);
}

int tab_u_print_n_malloc(){
  printf("tab_u_malloc=%d\n",tab_u_n_malloc);
  return tab_u_n_malloc;
}

int tab_u_print_n_free(){
  printf("tab_u_free=%d\n",tab_u_n_free);
  return tab_u_n_free;
}


Tab_u tab_u_init(){
  Tab_u t;
  t = (Tab_u)tab_u_malloc(sizeof(struct tab_u));
  if(t == NULL) return NULL;
  t->tab = NULL;
  t->n_elements = 0;
  t->MAX = 0;
  return t;
}

Ustring *tab_u_alloc_space(Ustring *t,int size){
  if(t == NULL){
    return (Ustring *)tab_u_malloc(size);
  }  
  return (Ustring *)realloc(t,size);
}

void tab_u_init_space(Ustring **t,int start,int tab_size){
  int i;

  for(i = start ; i < tab_size ; i++){
    (*t)[i] = NULL;
  }  
}

int tab_u_assign_value(Tab_u *t,int index,Ustring value){
  int size,start;
  if(*t == NULL){
    *t = tab_u_init();
    if(*t == NULL) return 1;
  }
  size = ((index/TAB_U_STEP_ALLOC)+1) * TAB_U_STEP_ALLOC;
  start = (*t)->MAX;
  if(index >= (*t)->MAX){
    (*t)->tab = tab_u_alloc_space((*t)->tab,size*sizeof(Ustring));
    (*t)->MAX = size;
  }
  if((*t)->tab == NULL) return 2;  
  tab_u_init_space(&((*t)->tab),start,(*t)->MAX);
  if((*t)->tab[index] == NULL){
    ((*t)->n_elements)++;
  }
  else{
    ustring_free((*t)->tab[index]);
  }
  (*t)->tab[index] = ustring_allocation(value);
  return 0;
}

Ustring tab_u_get_value(Tab_u t,int index){
  if(t == NULL) return NULL;
  if(t->MAX <= index){
    return NULL;
  }
  return t->tab[index];
}

int tab_u_get_n_elements(Tab_u t){
  if(t == NULL) return 0;
  return t->n_elements;
}

void tab_u_init_values(Tab_u *t,Ustring v, int length){
  int i;
  
  for(i = 0 ; i < length ; i++){
    tab_u_assign_value(t,i,v);
  }
}

int tab_u_get_MAX(Tab_u t){
  if(t == NULL) return 0;
  return t->MAX;
}

void tab_u_free(Tab_u *t){
  int i;
  if(*t == NULL) return;
  for(i = 0 ; i < (*t)->MAX ; i++){
    ustring_free((*t)->tab[i]);
  }
  tab_u_pfree((*t)->tab);
  tab_u_pfree(*t);
}


void tab_u_print(Tab_u t){
  int i;

  if(t == NULL){
    printf("NULL TAB_U ");
    return;
  }
  for(i = 0 ; i < t->MAX ; i++){
    printf("%d: ",i);
    ustring_println(t->tab[i]);
  }
}

void tab_u_print_codes(Tab_u t){
  int i;
  if(t == NULL){
    printf("NULL TAB_U ");
    return;
  }
  for(i = 0 ; i < t->MAX ; i++){
    printf("%d: ",i);
    ustring_println_codes(t->tab[i]);
  }
}

void tab_u_println(Tab_u t){
  tab_u_print(t);
  printf("\n");
}

void tab_u_println2(Tab_u t){
  tab_u_print_codes(t);
}
