#include <stdio.h>
#include <malloc.h>
#include "tab_ll.h"
#include "utilities.h"

int tab_ll_n_free = 0;
int tab_ll_n_malloc = 0;

void* tab_ll_malloc(int n){
  tab_ll_n_malloc++;
  return (void *)malloc(n);
}

void tab_ll_pfree(void *ptr){
  if(ptr == NULL) return;
  tab_ll_n_free++;
  free(ptr);
  ptr = NULL;
}

int tab_ll_print_n_malloc(){
  printf("tab_ll_malloc=%d\n",tab_ll_n_malloc);
  return tab_ll_n_malloc;
}

int tab_ll_print_n_free(){
  printf("tab_ll_free=%d\n",tab_ll_n_free);
  return tab_ll_n_free;
}

Tab_ll tab_ll_init(){
  Tab_ll t;
  t = (Tab_ll)tab_ll_malloc(sizeof(struct tab_ll));
  if(t == NULL) util_error("tab_ll_init","allocation of new tab_ll");
  t->tab = NULL;
  t->n_elements = 0;
  t->MAX = 0;
  return t;
}

Llist_l *tab_ll_alloc_space(Llist_l *t,int size){
  if(t == NULL){
    return (Llist_l *)tab_ll_malloc(size);
  }  
  return (Llist_l *)realloc(t,size);
}

void tab_ll_init_space(Llist_l **t,int start,int tab_size){
  int i;

  for(i = start ; i < tab_size ; i++){
    (*t)[i] = NULL;
  }  
}

void tab_ll_set_list(Tab_ll *t,int index,Llist_l l){
  int size,start;

if(*t == NULL){
    *t = tab_ll_init();
  }
  size = ((index/TAB_LL_STEP_ALLOC)+1) * TAB_LL_STEP_ALLOC;
  start = (*t)->MAX;
  if(index >= (*t)->MAX){
    (*t)->tab = tab_ll_alloc_space((*t)->tab,size*sizeof(Llist_l));
    (*t)->MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab_ll_assign_value","allocation of array in tab_ll");  
  tab_ll_init_space(&((*t)->tab),start,(*t)->MAX);
  if((*t)->tab[index] == NULL){
    ((*t)->n_elements)++;
  }
  ll_l_free(&((*t)->tab[index]));
  (*t)->tab[index] = l;
}


void tab_ll_insert_list(Tab_ll *t,int index, Llist_l *l){
  Llist_l temp;

  if(*l == NULL) return;  
  temp = tab_ll_get_list(*t,index);
  if(temp == NULL){
    tab_ll_set_list(t,index,*l);
  }
  else{
    ll_l_add_llist_l(&temp,*l);
    ll_l_light_free(l);//we do do not free the llists
  }
}


Llist_l tab_ll_get_list(Tab_ll t,int index){
  if(t == NULL) return NULL;
  if(t->MAX <= index){
    return NULL;
  }
  return t->tab[index];
}

int tab_ll_get_n_elements(Tab_ll t){
  if(t == NULL) return 0;
  return t->n_elements;
}
int tab_ll_get_MAX(Tab_ll t){
  if(t == NULL) return 0;
  return t->MAX;
}

void tab_ll_free(Tab_ll *t){
  int i;
  if(*t == NULL) return;
  for(i = 0 ; i < (*t)->MAX ; i++){    
    if((*t)->tab[i] != NULL){
      ll_l_free(&((*t)->tab[i]));
    }
  }
  tab_ll_pfree((*t)->tab);
  tab_ll_pfree(*t);
}

void tab_ll_print(Tab_ll t){
  int i;

  if(t == NULL){
    printf("NULL TAB_LL ");
    return;
  }
  for(i = 0 ; i < t->MAX ; i++){
    printf("[%d]\n",i);
    ll_l_println(t->tab[i]);
  }
}

void tab_ll_println(Tab_ll t){
  tab_ll_print(t);
}
