#ifndef _h_tab_l 
#define _h_tab_l

#include "llist.h"

#define TAB_L_STEP_ALLOC 8
#define TAB_L_HACHAGE_MAX 32768

// array of Llist

struct tab_l{
  Llist *tab;
  int n_elements;
  int MAX;
};

typedef struct tab_l * Tab_l;

// Functions

int tab_l_print_n_free();
int tab_l_print_n_malloc();
void tab_l_insert_value(Tab_l *t,int index,int key,int value); //insert at the head of the list at the index-th element of *t
void tab_l_insert_value_sorted(Tab_l *t,int index,int key,int value,int option); //insert sorted in the list according to keys (option = 0) or to values (1);
Llist tab_l_get_list(Tab_l t,int index);
void tab_l_set_list(Tab_l *t,int index,Llist l);
int tab_l_get_n_elements(Tab_l t);
int tab_l_get_MAX(Tab_l t);
void tab_l_free(Tab_l *t);
void tab_l_print(Tab_l t);
void tab_l_println(Tab_l t);


#endif
