#include <stdio.h>
#include <malloc.h>
#include "tab_i.h"
#include "llist.h"
#include "utilities.h"

int tab_i_n_free = 0;
int tab_i_n_malloc = 0;

void* tab_i_malloc(int n){
  tab_i_n_malloc++;
  return (void *)malloc(n);
}

void tab_i_pfree(void *ptr){
  if(ptr == NULL) return;
  tab_i_n_free++;
  free(ptr);
  ptr = NULL;
}

int tab_i_print_n_malloc(){
  printf("tab_i_malloc=%d\n",tab_i_n_malloc);
  return tab_i_n_malloc;
}

int tab_i_print_n_free(){
  printf("tab_i_free=%d\n",tab_i_n_free);
  return tab_i_n_free;
}


Tab_i tab_i_init(){
  Tab_i t;
  t = (Tab_i)tab_i_malloc(sizeof(struct tab_i));
  if(t == NULL) util_error("tab_i_init","allocation of new Tab_i");
  t->tab = NULL;
  t->n_elements = 0;
  t->MAX = 0;
  return t;
}

int *tab_i_alloc_space(int *t,int size){
  if(t == NULL){
    return (int *)tab_i_malloc(size);
  }  
  return (int *)realloc(t,size);
}

void tab_i_init_space(int **t,int start,int tab_size,int val){
  int i;

  for(i = start ; i < tab_size ; i++){
    (*t)[i] = val;
  }  
}

void tab_i_assign_value(Tab_i *t,int index,int value){
  int size,start;
  if(*t == NULL){
    *t = tab_i_init();
  }
  size = ((index/TAB_I_STEP_ALLOC)+1) * TAB_I_STEP_ALLOC;
  start = (*t)->MAX;
  if(index >= (*t)->MAX){
    (*t)->tab = tab_i_alloc_space((*t)->tab,size*sizeof(int));
    (*t)->MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab_i_assign_value","allocation of array in Tab_i");  
  tab_i_init_space(&((*t)->tab),start,(*t)->MAX,-1);
  if((*t)->tab[index] == -1){
    ((*t)->n_elements)++;
  }
  (*t)->tab[index] = value;
}

void tab_i_assign_value2(Tab_i *t,int index,int value,int init_val){
  int size,start;
  if(*t == NULL){
    *t = tab_i_init();
  }
  size = ((index/TAB_I_STEP_ALLOC)+1) * TAB_I_STEP_ALLOC;
  start = (*t)->MAX;
  if(index >= (*t)->MAX){
    (*t)->tab = tab_i_alloc_space((*t)->tab,size*sizeof(int));
    (*t)->MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab_i_assign_value2","allocation of array in Tab_i");
  tab_i_init_space(&((*t)->tab),start,(*t)->MAX,init_val);
  if((*t)->tab[index] == init_val){
    ((*t)->n_elements)++;
  }
  (*t)->tab[index] = value;
}

int tab_i_get_value(Tab_i t,int index){
  if(t == NULL) return -1;
  if(t->MAX <= index){
    return -1;
  }
  return t->tab[index];
}

int tab_i_get_n_elements(Tab_i t){
  if(t == NULL) return 0;
  return t->n_elements;
}
int tab_i_get_MAX(Tab_i t){
  if(t == NULL) return 0;
  return t->MAX;
}

Tab_i tab_i_load_ll(Llist l){
  Tab_i t = NULL;
  struct ll_cell *ptr;

  if(l == NULL) return NULL;
  ptr = l->head;
  while(ptr != NULL){
    tab_i_assign_value(&t,ptr->key,ptr->value);
    ptr = ptr->next;
  }
  return t;
}

Tab_i tab_i_load_ll_values(Llist l){
  Tab_i t = NULL;
  struct ll_cell *ptr;
  int cnt = 0;

  if(l == NULL) return NULL;
  ptr = l->head;
  while(ptr != NULL){
    tab_i_assign_value(&t,cnt,ptr->value);
    ptr = ptr->next;
    cnt++;
  }
  return t;
}

Tab_i tab_i_load_ll_keys(Llist l){
  Tab_i t = NULL;
  struct ll_cell *ptr;
  int cnt = 0;

  if(l == NULL) return NULL;
  ptr = l->head;
  while(ptr != NULL){
    tab_i_assign_value(&t,cnt,ptr->key);
    ptr = ptr->next;
    cnt++;
  }
  return t;
}


int tab_i_find_by_dicho(Tab_i t,int value){
  int i,val,start,end;
  if(t == NULL) return -1;
  if(t->n_elements == 0) return -1;
  start = 0;
  end = t->n_elements-1;
  while(end >= start){
    i = (end + start)/2;
    val = tab_i_get_value(t,i);
    if( val == value){
      return i;
    }  
    else{
      if(val < value){
	start = i+1;
      }
      else{
	end = i - 1;
      }
    }
  }
  if(val == value) return i;
  return -1;
}

void tab_i_free(Tab_i *t){
  if(*t == NULL) return;
  tab_i_pfree((*t)->tab);
  tab_i_pfree(*t);
}


void tab_i_print_char(Tab_i t){
   int i;

  if(t == NULL){
    printf("NULL TAB_I ");
    return;
  }
  for(i = 0 ; i < t->MAX ; i++){
    printf("%c::",t->tab[i]);
  }
  printf("\n");
}


void tab_i_print(Tab_i t){
  int i;

  if(t == NULL){
    printf("NULL TAB_I ");
    return;
  }
  for(i = 0 ; i < t->MAX ; i++){
    printf("%d ",t->tab[i]);
  }
}

void tab_i_println(Tab_i t){
  tab_i_print(t);
  printf("\n");
}

int tab_i_min(Tab_i tab){
  int i,n, min = 0,val;
  n = tab_i_get_n_elements(tab);
  if(n != 0) min = tab_i_get_value(tab,0);
  for(i = 0 ; i < n ; i++){
    val = tab_i_get_value(tab,i);
    if( val < min) min = val; 
  }
  return min;
}

int tab_i_max(Tab_i tab){
  int i,n, max = 0,val;

  n = tab_i_get_n_elements(tab);
  if(n != 0) max = tab_i_get_value(tab,0);
  for(i = 0 ; i < n ; i++){
    val = tab_i_get_value(tab,i);
    if( val > max) max = val; 
  }
  return max;
}


// sort tab_i
//option = 0 in increasing order
//option = 1 in decreasing order 
//out_option = 0 : return tab contains ids
//out_option = 1 : return tab contains values 


// THERE IS A BUG SOMEWHERE

Tab_i tab_i_sort_function(Tab_i tab,int option,int out_option){
  Tab_i temp = NULL,temp2 = NULL;
  Llist l[TAB_I_HACHAGE_MAX];
  struct ll_cell *ptr;
  int i = 0,max,n,cnt,val,index;

  if(tab == NULL) return NULL;
  max = tab_i_max(tab);
  for(i = 0 ; i < TAB_I_HACHAGE_MAX ; i++ ) l[i] = NULL;
  n = tab_i_get_n_elements(tab);
  for(i = 0 ; i < n ; i++){
    val = tab_i_get_value(tab,i);
    index = (int)(val*TAB_I_HACHAGE_MAX/(max + 1)); // make it more flexible
    //printf("%d,%d\n",index,TAB_I_HACHAGE_MAX);
    ll_insert_sorted(&(l[index]),i,val,1);
  }
  cnt = 0;
  for(i = 0 ; i < TAB_I_HACHAGE_MAX ; i++ ){
    if(l[i] != NULL){
      ptr = l[i]->head;
      while(ptr != NULL){
	if(!out_option)tab_i_assign_value(&temp,cnt,ptr->key);
	else tab_i_assign_value(&temp,cnt,ptr->value);
	cnt++;
	ptr = ptr->next;
      }
    }    
  }
  for(i = 0 ; i < TAB_I_HACHAGE_MAX ; i++ ) ll_free(&(l[i]));
  if(option){
    for(i = 0 ; i < n ; i++ ){
      tab_i_assign_value(&temp2,n-i-1,tab_i_get_value(temp,i));
    }
    tab_i_free(&temp);
    return temp2;
  }
  return temp;
}


Tab_i tab_i_sort(Tab_i tab,int option){
  return tab_i_sort_function(tab,option,1);
}

Tab_i tab_i_sort2(Tab_i tab,int option){
  return tab_i_sort_function(tab,option,0);
}


Tab_i tab_i_copy(Tab_i t){
  Tab_i temp = NULL;
  int i;
  if(t == NULL) return NULL;
  for(i = 0 ; i < tab_i_get_MAX(t) ; i++){
    tab_i_assign_value(&temp,i,tab_i_get_value(t,i));
  }
  return temp;
}
