#include <malloc.h>
#include <stdio.h>
#include "tab_feat.h"
#include "utilities.h"

int tab_feat_n_free = 0;
int tab_feat_n_malloc = 0;

void* tab_feat_malloc(int n){
  tab_feat_n_malloc++;
  return (void *)malloc(n);
}

void tab_feat_pfree(void *ptr){
  if(ptr == NULL) return;
  tab_feat_n_free++;
  free(ptr);
  ptr = NULL;
}

int tab_feat_print_n_malloc(){
  printf("tab_feat_malloc=%d\n",tab_feat_n_malloc);
  return tab_feat_n_malloc;
}

int tab_feat_print_n_free(){
  printf("tab_feat_free=%d\n",tab_feat_n_free);
  return tab_feat_n_free;
}

Tab_feat tab_feat_init(){
  Tab_feat t = (Tab_feat)tab_feat_malloc(sizeof(struct tab_feat));
  if(t == NULL) util_error("tab_feat_init","cannot init tab_feat");
  t->n_elements = 0;
   t->features = NULL;
  t->ht_types = hash_init(TAB_FEAT_HT_LABELS_SIZE);
  t->ht_labels = hash_init(TAB_FEAT_HT_TYPES_SIZE);

  return t;
}

Boolean_feature *tab_feat_init_tab_space(Boolean_feature *bf,int size){
  if(size == 0) bf = NULL;
  else if(size == 1)
    bf = (Boolean_feature *)tab_feat_malloc(1*sizeof(Boolean_feature));
  else
     bf = (Boolean_feature *)realloc(bf,size*sizeof(Boolean_feature));
  return bf;
}

Boolean_feature tab_feat_create_boolean_feature(int type,int label){
  Boolean_feature f = (Boolean_feature)tab_feat_malloc(sizeof(struct boolean_feature));
  if(f == NULL) util_error("tab_feat_create_boolean_feature","memory allocation");
  f->type = type;
  f->label = label;
  return f;
}

int tab_feat_add_element(Tab_feat *t,int type,int label){
  int id;
  if(*t == NULL) (*t) = tab_feat_init();
  if((id = hash_get_id((*t)->ht_labels,label,type)) == -1){
    id = (*t)->n_elements;
    (*t)->features = tab_feat_init_tab_space((*t)->features,id +1);
    (*t)->features[id] = tab_feat_create_boolean_feature(type,label);
    hash_add_element(&((*t)->ht_labels),label,type,id);
    hash_add_element(&((*t)->ht_types),type,label,id);
    ((*t)->n_elements)++;
  }
  return id;
}

Boolean_feature tab_feat_get_element(Tab_feat t,int type){
  Boolean_feature bf = NULL;

  return bf;
}


void tab_feat_print(Tab_feat t){
  int i;
  if(t == NULL){
    printf("{empty tab_feat}\n");
    return;
  }
  for(i = 0 ; i < t->n_elements ; i++){
    printf("%d:(%d,%d)\n",i,t->features[i]->type,t->features[i]->label);
  }
}

void tab_feat_println(Tab_feat t){
  tab_feat_print(t);
}

void tab_feat_free(Tab_feat *t){
  int i;
  if(*t == NULL) return;
  for(i = 0 ; i < (*t)->n_elements ; i++){
    tab_feat_pfree((*t)->features[i]);
  }
  tab_feat_pfree((*t)->features);
  hash_free((*t)->ht_labels);
  hash_free((*t)->ht_types);
  tab_feat_pfree(*t);
}
