#include <stdio.h>
#include <malloc.h>
#include "tab_d.h"
#include "llist_d.h"
#include "utilities.h"

int tab_d_n_free = 0;
int tab_d_n_malloc = 0;

void* tab_d_malloc(int n){
  tab_d_n_malloc++;
  return (void *)malloc(n);
}

void tab_d_pfree(void *ptr){
  if(ptr == NULL) return;
  tab_d_n_free++;
  free(ptr);
  ptr = NULL;
}

int tab_d_print_n_malloc(){
  printf("tab_d_malloc=%d\n",tab_d_n_malloc);
  return tab_d_n_malloc;
}

int tab_d_print_n_free(){
  printf("tab_d_free=%d\n",tab_d_n_free);
  return tab_d_n_free;
}


Tab_d tab_d_init(){
  Tab_d t;
  t = (Tab_d)tab_d_malloc(sizeof(struct tab_d));
  if(t == NULL) util_error("tab_d_init","allocation of new Tab_d");
  t->tab = NULL;
  t->n_elements = 0;
  t->MAX = 0;
  return t;
}

double *tab_d_alloc_space(double *t,int size){
  if(t == NULL){
    return (double *)tab_d_malloc(size);
  }  
  return (double *)realloc(t,size);
}

void tab_d_init_space(double **t,int start,int tab_size,double val){
  int i;

  for(i = start ; i < tab_size ; i++){
    (*t)[i] = val;
  }  
}

void tab_d_assign_value(Tab_d *t,int index,double value){
  int size,start;
  if(*t == NULL){
    *t = tab_d_init();
  }
  size = ((index/TAB_D_STEP_ALLOC)+1) * TAB_D_STEP_ALLOC;
  start = (*t)->MAX;
  if(index >= (*t)->MAX){
    (*t)->tab = tab_d_alloc_space((*t)->tab,size*sizeof(double));
    (*t)->MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab_d_assign_value","allocation of array in Tab_d");  
  tab_d_init_space(&((*t)->tab),start,(*t)->MAX,0.0);
  if((*t)->tab[index] == 0.0){
    ((*t)->n_elements)++;
  }
  (*t)->tab[index] = value;
}

void tab_d_assign_value2(Tab_d *t,int index,double value,double init_val){
  int size,start;
  if(*t == NULL){
    *t = tab_d_init();
  }
  size = ((index/TAB_D_STEP_ALLOC)+1) * TAB_D_STEP_ALLOC;
  start = (*t)->MAX;
  if(index >= (*t)->MAX){
    (*t)->tab = tab_d_alloc_space((*t)->tab,size*sizeof(double));
    (*t)->MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab_d_assign_value2","allocation of array in Tab_d");
  tab_d_init_space(&((*t)->tab),start,(*t)->MAX,init_val);
  if((*t)->tab[index] == init_val){
    ((*t)->n_elements)++;
  }
  (*t)->tab[index] = value;
}

double tab_d_get_value(Tab_d t,int index){
  if(t == NULL) return 0.0;
  if(t->MAX <= index){
    return 0.0;
  }
  return t->tab[index];
}

int tab_d_get_n_elements(Tab_d t){
  if(t == NULL) return 0;
  return t->n_elements;
}
int tab_d_get_MAX(Tab_d t){
  if(t == NULL) return 0;
  return t->MAX;
}

int tab_d_find_by_dicho(Tab_d t,double value){
  int i,start,end;
  double val;

  if(t == NULL) return -1;
  if(t->n_elements == 0) return -1;
  start = 0;
  end = t->n_elements-1;
  while(end >= start){
    i = (end + start)/2;
    val = tab_d_get_value(t,i);
    if( val == value){
      return i;
    }  
    else{
      if(val < value){
	start = i+1;
      }
      else{
	end = i - 1;
      }
    }
  }
  if(val == value) return i;
  return -1;
}

void tab_d_free(Tab_d *t){
  if(*t == NULL) return;
  tab_d_pfree((*t)->tab);
  tab_d_pfree(*t);
}


void tab_d_print(Tab_d t){
  int i;

  if(t == NULL){
    printf("NULL TAB_D ");
    return;
  }
  for(i = 0 ; i < t->MAX ; i++){
    printf("%f ",t->tab[i]);
  }
}

void tab_d_println(Tab_d t){
  tab_d_print(t);
  printf("\n");
}

double tab_d_min(Tab_d tab){
  int i,n;
  double min = 0.0,val;
  n = tab_d_get_n_elements(tab);
  if(n != 0) min = tab_d_get_value(tab,0);
  for(i = 0 ; i < n ; i++){
    val = tab_d_get_value(tab,i);
    if( val < min) min = val; 
  }
  return min;
}

double tab_d_max(Tab_d tab){
  int i,n; 
  double max = 0,val;

  n = tab_d_get_n_elements(tab);
  if(n != 0) max = tab_d_get_value(tab,0);
  for(i = 0 ; i < n ; i++){
    val = tab_d_get_value(tab,i);
    if( val > max) max = val; 
  }
  return max;
}


// sort tab_i
//option = 0 in increasing order
//option = 1 in decreasing order 


Tab_d tab_d_sort(Tab_d tab,int option){
  Tab_d temp = NULL,temp2 = NULL;
  Llist_d l[TAB_D_HACHAGE_MAX];
  struct ll_d_cell *ptr;
  int i = 0,n,cnt,index;
  double max,val;

  max = tab_d_max(tab);
  for(i = 0 ; i < TAB_D_HACHAGE_MAX ; i++ ) l[i] = NULL;
  n= tab_d_get_n_elements(tab);
  for(i = 0 ; i < n ; i++){
    val = tab_d_get_value(tab,i);
    index = (int)(val*TAB_D_HACHAGE_MAX/(max + 1));
    ll_d_insert_sorted(&(l[index]),i,val,1);
  }
  cnt = 0;
  for(i = 0 ; i < TAB_D_HACHAGE_MAX ; i++ ){
    if(l[i] != NULL){
      ptr = l[i]->head;
      while(ptr != NULL){
	tab_d_assign_value(&temp,cnt,ptr->value);
	cnt++;
	ptr = ptr->next;
      }
    }    
  }
  if(option){
    for(i = 0 ; i < n ; i++ ){
      tab_d_assign_value(&temp2,n-i-1,tab_d_get_value(temp,i));
    }
    tab_d_free(&temp);
    return temp2;
  }
  return temp;
}

Tab_d tab_d_copy(Tab_d t){
  Tab_d temp = NULL;
  int i;
  if(t == NULL) return NULL;
  for(i = 0 ; i < tab_d_get_MAX(t) ; i++){
    tab_d_assign_value(&temp,i,tab_d_get_value(t,i));
  }
  return temp;
}
