#include <stdio.h>
#include <malloc.h>
#include "tab2_i.h"
#include "utilities.h"

int tab2_i_n_free = 0;
int tab2_i_n_malloc = 0;

void* tab2_i_malloc(int n){
  tab2_i_n_malloc++;
  return (void *)malloc(n);
}

void tab2_i_pfree(void *ptr){
  if(ptr == NULL) return;
  tab2_i_n_free++;
  free(ptr);
  ptr = NULL;
}

int tab2_i_print_n_malloc(){
  printf("tab2_i_malloc=%d\n",tab2_i_n_malloc);
  return tab2_i_n_malloc;
}

int tab2_i_print_n_free(){
  printf("tab2_i_free=%d\n",tab2_i_n_free);
  return tab2_i_n_free;
}

Tab2_i tab2_i_init(){
  Tab2_i t = (Tab2_i)tab2_i_malloc(sizeof(struct tab2_i));
  if(t == NULL) util_error("tab2_i_init","allocation of tab2_i");
  t->n_rows = 0;
  t->n_rows_MAX = 0;
  t->n_columns = 0;
  t->tab = NULL;
  return t;
}

Tab_i *tab2_i_alloc_space(Tab_i *t,int size){
  if(t == NULL){
    return (Tab_i *)tab2_i_malloc(size);
  }  
  return (Tab_i *)realloc(t,size);
}

void tab2_i_init_space(Tab_i **t,int start,int tab_size){
  int i;

  for(i = start ; i < tab_size ; i++){
    (*t)[i] = NULL;
  }  
}


void tab2_i_assign_value(Tab2_i *t,int i,int j,int value){
  int size,start;

  if(*t == NULL){

    *t = tab2_i_init();
  }
  start = (*t)->n_rows_MAX;
  size = ((i/TAB2_I_STEP_ALLOC)+1)*TAB2_I_STEP_ALLOC;
  if((*t)->n_rows_MAX <= i){
    (*t)->tab = tab2_i_alloc_space((*t)->tab,size*sizeof(struct tab2_i));
    (*t)->n_rows_MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab2_i_assign_value","allocation of row vector");; 
  tab2_i_init_space(&((*t)->tab),start,(*t)->n_rows_MAX);
  if((*t)->tab[i] == NULL){
    ((*t)->n_rows)++;
  }
  tab_i_assign_value2(&((*t)->tab[i]),j,value,0);
}

int tab2_i_get_value(Tab2_i t,int i,int j){
  if(t == NULL) return -1;
  if(i >= t->n_rows_MAX) return -1;
  return tab_i_get_value(t->tab[i],j);
}

int tab2_i_get_n_rows_MAX(Tab2_i t){
  if(t == NULL) return 0;
  return (t->n_rows_MAX);
}

int tab2_i_get_n_columns_MAX(Tab2_i t,int i){
  if(t == NULL) return 0;
  if(t->tab == NULL) return 0;
  if(i >= t->n_rows_MAX) return 0;
  return tab_i_get_MAX(t->tab[i]);
}

void tab2_i_free(Tab2_i *t){  
  int i;
  if(*t == NULL) return;
  for(i = 0 ; i < (*t)->n_rows_MAX ; i++){
    tab_i_free(&((*t)->tab[i])); 
  }
  tab2_i_pfree((*t)->tab);
  tab2_i_pfree(*t);
}


void tab2_i_print(Tab2_i t){
  int i;

  if((t == NULL)||(t->tab == NULL)){
    printf("[empty matrix]");
    return;
  }
  printf("-------- MATRIX --------\n");
  for(i = 0 ; i < t->n_rows_MAX ; i++){
    printf("%d::",i);
    tab_i_println(t->tab[i]);
  }
  printf("------------------------\n");
}

void tab2_i_println(Tab2_i t){
  tab2_i_print(t);
  printf("\n");
}
