#ifndef _h_s_ana 
#define _h_s_ana

#include "ustring.h"
#include "hashtable.h"
#include "lexicon.h"

#define SA_TREE_SIZE 100
#define SA_HASH_SIZE 20

struct sa_feature{
  int label;
  int value; // positive value : index of token ; 
  // a negative value : -index -1 (index of syntactic node in array)
};

struct syntactic_node{
  int pattern; //index of token
  Llist_i sn_list; //list of snodes (index of these nodes)
  Hashtable features;
};

typedef struct syntactic_node *Syntactic_node;

struct syntactic_tree{
  int size;
  int MAX;
  Syntactic_node *tab;
};

typedef struct syntactic_tree *Syntactic_tree;


//functions

int sa_print_n_malloc();
int sa_print_n_free();
void sa_init_tree(Syntactic_tree *tree); //with root creation
void sa_init_tree2(Syntactic_tree *tree);//without root creation
int sa_add_tree_node(Syntactic_tree *tree,struct syntactic_node *snode);
void sa_add_node_feature(Syntactic_node *node,int type,int value);
void sa_set_node_pattern(Syntactic_node *node,int p);
void sa_add_node_sn_list_element(Syntactic_node *node,int sn_node);
void sa_print_tree(Syntactic_tree tree, Lexicon lex,int header);
void sa_free_tree(Syntactic_tree *tree);
Syntactic_node sa_get_tree_node(Syntactic_tree tree,int index);
struct syntactic_node *sa_create_node();
void sa_add_tree_transition(Syntactic_tree *tr,int src,int dest);
int sa_get_feature_value(Syntactic_tree tree,int feature_key,int node);

#endif
