#include <stdio.h>
#include <malloc.h>
#include "static_tree2.h"
#include "ustring.h"
#include "utilities.h"

int stree2_n_free = 0;
int stree2_n_malloc = 0;

void* stree2_malloc(int n){
  stree2_n_malloc++;
  return (void *)malloc(n);
}

void stree2_pfree(void *ptr){
  if(ptr == NULL) return;
  stree2_n_free++;
  free(ptr);
  ptr = NULL;
}

int stree2_print_n_malloc(){
  printf("stree2_malloc=%d\n",stree2_n_malloc);
  return stree2_n_malloc;
}

int stree2_print_n_free(){
  printf("stree2_free=%d\n",stree2_n_free);
  return stree2_n_free;
}

struct stree2_node * stree2_create_node(int c){
  struct stree2_node *ptr = (struct stree2_node *)stree2_malloc(sizeof(struct stree2_node));
  if(ptr == NULL) util_error("stree2_create_node","creating tree node");
  ptr->n_siblings = 0;
  ptr->siblings = NULL;
  ptr->letters = NULL;
  ptr->previous = NULL;
  ptr->mark = -1;
  return ptr;
}

void stree2_from_tree2(struct stree2_node **sroot,struct tree2_node *root){
  

}


/*
struct stree2_cell_node *stree2_create_cell_node(struct stree2_node *n){
  struct stree2_cell_node *ptr = (struct stree2_cell_node *)stree2_malloc(sizeof(struct stree2_cell_node));
  if(ptr == NULL) util_error("stree2_create_cell_node","creating tree cell_node");
  ptr->n = n;
  ptr->next = NULL;
  return ptr;
}


struct stree2_node * stree2_letter_exists(struct stree2_node *n,int l){
  struct stree2_cell_node *ptr; 
  ptr = n->nodes;
  while(ptr != NULL){
    if((ptr->n != NULL) && (ptr->n->letter == l)) return ptr->n;
    ptr = ptr->next;
  }
  return NULL;
}

void stree2_insert_cell_node(List_stree2_nodes *l,struct stree2_node *n){
  struct stree2_cell_node *ptr = stree2_create_cell_node(n);
  ptr->next = *l;
  *l = ptr;
}


struct stree2_node * stree2_insert_letter(struct stree2_node *n,int l){
  struct stree2_node *ptr;
  if((ptr = stree2_letter_exists(n,l)) == NULL){
    ptr = stree2_create_node(l);
    ptr->previous = n;
    stree2_insert_cell_node(&(n->nodes),ptr);
  }
  return ptr;
}

struct stree2_node* stree2_insert_word(struct stree2_node **root,int *w,int mark){
  int i;
  struct stree2_node *ptr = *root;
  for(i = 0 ; i < ustring_length(w) ; i++){
    ptr = stree2_insert_letter(ptr,w[i]);
  }
  ptr->mark = mark;
  return ptr;
}

int stree2_word_exists(struct stree2_node *root,int *w){
  int i;
  struct stree2_node *ptr = root;

  for(i = 0 ; i < ustring_length(w) ; i++){
    if((ptr = stree2_letter_exists(ptr,w[i])) == NULL) return -1;
  }
  return ptr->mark;
}

struct stree2_node *stree2_init(){
  return stree2_create_node(0);
}


void stree2_free(struct stree2_node **n){
  struct stree2_cell_node *ptr = (*n)->nodes;
  struct stree2_cell_node *p;

  while(ptr != NULL){
    stree2_free(&(ptr->n));
    p = ptr;
    ptr = ptr->next;
    stree2_pfree(p);
  }  
  stree2_pfree(*n);
}

Ustring stree2_get_element(struct stree2_node *n){
  Uchar u[USTRING_LENGTH_MAX];
  Ustring s = NULL;
  struct stree2_node *ptr = n;
  int i = 0;

  while(ptr != NULL){
    if(i == USTRING_LENGTH_MAX - 1) util_error("stree2_get_element","USTRING_LENGTH_MAX too short");
    u[i]= ptr->letter;
    ptr = ptr->previous;
    i++;
  }
  u[i] = 0;
  s = ustring_allocation(u);
  ustring_invert(&s);
  return s;
}
*/
