#include <stdio.h>
#include <malloc.h>
#include "set_ll.h"
#include "utilities.h"

int set_ll_n_free = 0;
int set_ll_n_malloc = 0;

void* set_ll_malloc(int n){
  set_ll_n_malloc++;
  return (void *)malloc(n);
}

void set_ll_pfree(void *ptr){
  if(ptr == NULL) return;
  set_ll_n_free++;
  free(ptr);
  ptr = NULL;
}

int set_ll_print_n_malloc(){
  printf("set_ll_malloc=%d\n",set_ll_n_malloc);
  return set_ll_n_malloc;
}

int set_ll_print_n_free(){
  printf("set_ll_free=%d\n",set_ll_n_free);
  return set_ll_n_free;
}

Set_ll set_ll_intersection(Set_ll s1,Set_ll s2){
  Set_ll s = NULL;
  int val1,val2;
  struct ll_i_cell* ptr1,*ptr2;

  if(s1 == NULL) return NULL;
  if(s2 == NULL) return NULL;
  ptr1 = s1->head;
  ptr2 = s2->head;
  
  while((ptr1 != NULL) && (ptr2 != NULL)){
    val1 = ptr1->value;
    val2 = ptr2->value;
    if(val1 == val2){
      ll_i_insert_at_tail(&s,val1);
      ptr1 = ptr1->next;
      ptr2 = ptr2->next;
    }
    else{
      if(val1 < val2){
	ptr1 = ptr1->next;
      }
      else{
	ptr2 = ptr2->next;
      }
    }    
  }
  return s;
}

Set_ll set_ll_union(Set_ll s1,Set_ll s2){
  Set_ll s = NULL;
  struct ll_i_cell *ptr1,*ptr2;
  int val1,val2;

  if(s1 == NULL) ptr1 = NULL;
  else ptr1 = s1->head;
  if(s2 == NULL) ptr2 = NULL;
  else ptr2 = s2->head;

  while((ptr1 != NULL) || (ptr2 != NULL)){
    if(ptr1 == NULL){
      ll_i_insert_at_tail(&s,ptr2->value);
      ptr2 = ptr2->next;
    }
    else if(ptr2 == NULL){
      ll_i_insert_at_tail(&s,ptr1->value);
      ptr1 = ptr1->next;
    }
    else{
      val1 = ptr1->value;
      val2 = ptr2->value;
      if(val1 == val2){
	ll_i_insert_at_tail(&s,val1);
	ptr1 = ptr1->next;
	ptr2 = ptr2->next;
      }
      else if(val1 < val2){
	ll_i_insert_at_tail(&s,val1);
	ptr1 = ptr1->next;
      }
      else{
	ll_i_insert_at_tail(&s,val2);
	ptr2 = ptr2->next;
      }      
    }    
  }

  return s;
}


int set_ll_exists(Set_ll s,int elem){
  if(ll_i_find_element(s,elem) == NULL) return 0;
  return 1;
}

void set_ll_add_element(Set_ll *s,int elem){
  if(set_ll_exists(*s,elem)) return;
  ll_i_insert_sorted(s,elem);
}

void set_ll_print(Set_ll s){
  struct ll_i_cell * ptr;

  if(s == NULL){
    printf("(empty)");
    return;
  }
  ptr = s->head;
  printf("(");
  while(ptr != NULL){
    printf("%d;",ptr->value);
    ptr = ptr->next;
  }
  printf(")");
}

void set_ll_println(Set_ll t){
  set_ll_print(t);
  printf("\n");
}

void set_ll_flush(Set_ll *s){
  set_ll_free(s);
}

void set_ll_free(Set_ll *s){
  ll_i_free(s);
}
