#include <stdio.h>
#include <malloc.h>
#include "set_icc.h"
#include "utilities.h"

int set_icc_n_free = 0;
int set_icc_n_malloc = 0;

void* set_icc_malloc(int n){
  set_icc_n_malloc++;
  return (void *)malloc(n);
}

void set_icc_pfree(void *ptr){
  if(ptr == NULL) return;
  set_icc_n_free++;
  free(ptr);
  ptr = NULL;
}

int set_icc_print_n_malloc(){
  printf("set_icc_malloc=%d\n",set_icc_n_malloc);
  return set_icc_n_malloc;
}

int set_icc_print_n_free(){
  printf("set_icc_free=%d\n",set_icc_n_free);
  return set_icc_n_free;
}
Set_icc set_icc_intersection(Set_icc s1,Set_icc s2){
  Set_icc s = NULL;

  struct ll_cell *ptr1,*ptr2;
  if(s1 == NULL) return NULL;
  if(s2 == NULL) return NULL;
  ptr1 = s1->head;
  ptr2 = s2->head;
  while((ptr1 != NULL)&&(ptr2 != NULL)){
    if(ptr1->key < ptr2->key) ptr1 = ptr1->next;
    else if(ptr1 -> key > ptr2->key) ptr2 = ptr2->next;
    else{ 
      ll_insert_at_tail(&s,ptr1->key,(ptr1->value)&(ptr2->value));
       ptr1 = ptr1->next;
       ptr2 = ptr2->next;
    }  
  }
  return s;
}

Set_icc set_icc_union(Set_icc s1,Set_icc s2){
  Set_icc s = NULL;
  struct ll_cell *ptr1,*ptr2;

  if(s1 == NULL) ptr1 = NULL;
  else ptr1 = s1->head;
  if(s2 == NULL) ptr2 = NULL;
  else ptr2 = s2->head;
  
  while((ptr1 != NULL) && (ptr2 != NULL)){
    if(ptr1->key < ptr2->key) {
      ll_insert_at_tail(&s,ptr1->key,ptr1->value);
      ptr1 = ptr1->next;
    }
    else if(ptr1 -> key > ptr2->key) {
      ll_insert_at_tail(&s,ptr2->key,ptr2->value);
      ptr2 = ptr2->next;
    }
    else{ 
      ll_insert_at_tail(&s,ptr1->key,(ptr1->value)|(ptr2->value));
      ptr1 = ptr1->next;
      ptr2 = ptr2->next;
    }  
  }
  while(ptr1 != NULL){
    ll_insert_at_tail(&s,ptr1->key,ptr1->value);
    ptr1 = ptr1->next;
  }
  while(ptr2 != NULL){
    ll_insert_at_tail(&s,ptr2->key,ptr2->value);
    ptr2 = ptr2->next;
  }

  return s;
}

int set_icc_exists(Set_icc s,int elem){
  int n_b,key,val,size,val2;
  struct ll_cell *ptr;

  size = 8*sizeof(int);
  key =  elem/size;
  n_b = elem % size;
  val = 1;
  val = val << n_b;
  ptr = ll_find_element(s,key,0);
  if(ptr == NULL) return 0;
  val2 = ptr->value;

  return (val & val2);
}

//2 passes: find then assign
// Costly, implement direct addition

int set_icc_add_element(Set_icc *s,int elem){
  int n_b,key,val,size;
  struct ll_cell *ptr;

  size = 8*sizeof(int);
  key =  elem/size;
  n_b = elem%size;
  val = 1;
  val = val << n_b;
  ptr = ll_find_element(*s,key,0);
  if(ptr == NULL) ll_insert_sorted(s,key,val,0);
  ptr->value |= val;   
  return 0;
}

int set_icc_rm_element(Set_icc *s,int elem){
  int n_b,key,val,size;
  struct ll_cell *ptr;
  
  size = 8*sizeof(int);
  key =  elem/size;
  n_b = elem % size;
  val = 1;
  val = val << n_b;
  ptr = ll_find_element(*s,elem/size,0);
  if(ptr == NULL) return 0;
  ptr->value = util_bit_removal(val,ptr->value);   
  return 0;
}


void set_icc_print(Set_icc s){
  int k,key,val,value,size;
  struct ll_cell * ptr;

  if(s == NULL){
    printf("(empty)");
    return;
  }
  printf("(");
  ptr = s->head;
  size = 8* sizeof(int);
  while(ptr!= NULL){
    key = ptr->key;
    value = ptr->value;
    for(k = 0 ; k < size ; k++){
      val = 1;
      val = val << k;
      if(value & val){
	printf("%d;",size*key+k);
      }
    }    
    ptr = ptr->next;
  }
  printf(")");
}

void set_icc_println(Set_icc t){
  set_icc_print(t);
  printf("\n");
}

void set_icc_flush(Set_icc *s){
  set_icc_free(s);
}

void set_icc_free(Set_icc *s){
  ll_free(s);
}

