#include <stdio.h>
#include <malloc.h>
#include "set_i.h"
#include "utilities.h"

int set_i_n_free = 0;
int set_i_n_malloc = 0;

void* set_i_malloc(int n){
  set_i_n_malloc++;
  return (void *)malloc(n);
}

void set_i_pfree(void *ptr){
  if(ptr == NULL) return;
  set_i_n_free++;
  free(ptr);
  ptr = NULL;
}

int set_i_print_n_malloc(){
  printf("set_i_malloc=%d\n",set_i_n_malloc);
  return set_i_n_malloc;
}

int set_i_print_n_free(){
  printf("set_i_free=%d\n",set_i_n_free);
  return set_i_n_free;
}

Set_i set_i_intersection(Set_i s1,Set_i s2){
  Set_i s = NULL;
  int i,l1,l2,l,val1,val2;

  if(s1 == NULL) return NULL;
  if(s2 == NULL) return NULL;
  l1 = tab_i_get_MAX(s1);
  l2 = tab_i_get_MAX(s2);
  l = util_min(l1,l2);
  for(i = 0 ; i < l ; i++){
    val1 = tab_i_get_value(s1,i);
    val2 = tab_i_get_value(s2,i);
    tab_i_assign_value2(&s,i,val1 & val2,0);
  }
  return s;
}

Set_i set_i_union(Set_i s1,Set_i s2){
  Set_i s = NULL;
  int i,l1,l2,l,val1,val2;

  l1 = tab_i_get_MAX(s1);
  l2 = tab_i_get_MAX(s2);
  l = util_max(l1,l2);
  for(i = 0 ; i < l ; i++){
    val1 = tab_i_get_value(s1,i);
    if(val1 == -1) val1 = 0;    
    val2 = tab_i_get_value(s2,i);
    if(val2 == -1) val2 = 0;
    tab_i_assign_value2(&s,i,val1 | val2,0);
  }
  return s;
}

int set_i_exists(Set_i s,int elem){
  int n_b,index,val,size,val2;

  size = 8*sizeof(int);
  index = elem/size;
  n_b = elem % size;
  val = 1;
  val = val << n_b;
  val2 = tab_i_get_value(s,index);
  if(val2 == -1){
    return 0;
  }
  return (val & val2);
}

void set_i_add_element(Set_i *s,int elem){
  int n_b,index,val,size,val2;

  size = 8*sizeof(int);
  index = elem/size;
  n_b = elem % size;
  val = 1;
  val = val << n_b;
  val2 = tab_i_get_value(*s,index);
  if(val2 == -1){
    val2 = 0;
  }
  val |= val2; 
  tab_i_assign_value2(s,index,val,0);
}

void set_i_rm_element(Set_i *s,int elem){
  int n_b,index,val,size,val2;

  size = 8*sizeof(int);
  index = elem/size;
  n_b = elem%size;
  val = 1;
  val = val << n_b;
  val2 = tab_i_get_value(*s,index);
  if(val2 == -1){
    return;
  }
  val = util_bit_removal(val,val2); 
  tab_i_assign_value2(s,index,val,0);
}


void set_i_print(Set_i t){
  int i,j,cnt,val,size;
 
  if(t == NULL){
    printf("(empty)");
    return;
  }
  cnt = 0;
  size = 8* sizeof(int);
  printf("(");
  for(i = 0 ; i < t->MAX ; i++){
    for(j = 0 ; j < size ; j++){
      val = 1;
      val = val << j;
      if(t->tab[i] & val){
	printf("%d;",cnt);
      }
      cnt++;
    }
  }
  printf(")");
}

void set_i_println(Set_i t){
  set_i_print(t);
  printf("\n");
}

void set_i_flush(Set_i *s){
  set_i_free(s);
}

void set_i_free(Set_i *s){
  tab_i_free(s);
}
