#include "match.h"
#include "llist.h"
#include <stdio.h>
#include <malloc.h>
#include "utilities.h"

int match_n_free = 0;
int match_n_malloc = 0;

void* match_malloc(int n){
  match_n_malloc++;
  return (void *)malloc(n);
}

void match_pfree(void *ptr){
  if(ptr == NULL) return;
  match_n_free++;
  free(ptr);
  ptr = NULL;
}

int match_print_n_malloc(){
  printf("match_malloc=%d\n",match_n_malloc);
  return match_n_malloc;
}

int match_print_n_free(){
  printf("match_free=%d\n",match_n_free);
  return match_n_free;
}


Match_tree match_init_tree(){
  Match_tree mt = NULL;
  
  mt = (Match_tree)match_malloc(sizeof(struct match_tree));
  if(mt == NULL) util_error("match_init_tree","initialization of match_tree");
  mt->tree = NULL;
  mt->finaux = NULL;
  mt->initiaux = NULL;

  return mt;
}


Match_node match_init(){
  Match_node n;

  n = (Match_node)match_malloc(sizeof(struct match));
  if(n == NULL) util_error("match_init","initialization of match");
  n->length = 0;
  n->match_result = -1;
  n->output = -1;
  n->final = 0;
  n->weight = 1.0;
  n->children = NULL;
  n->parent = -1;
  n->recognized = NULL;
  n->analysis = NULL;
  n->subauto_open = -1; 
  n->subauto_close = -1;
  return n;
}

Match_node match_create(int l,int res,int output,double weight,Llist analysis,Llist recognized){
  Match_node n = match_init();
  n->length = l;
  n->match_result = res;
  n->output = output;
  n->weight = weight;
  n->analysis = analysis;
  n->recognized = recognized;
  return n;
}


void match_set_subauto_close(Match_node n,int subauto){
  if(n == NULL) return;
  n->subauto_close = subauto;
}

void match_set_subauto_open(Match_node n,int subauto){
  if(n == NULL) return;
  n->subauto_open = subauto;
}


Tab_m match_tab_m_init(){
  Tab_m t;
  t = (Tab_m)match_malloc(sizeof(struct tab_m));
  if(t == NULL) util_error("tab_m_init","allocation of new Tab_m");
  t->tab = NULL;
  t->n_elements = 0;
  t->MAX = 0;
  return t;
}

Match_node* match_tab_m_alloc_space(Match_node *t,int size){
  if(t == NULL){
    return (Match_node *)match_malloc(size);
  }  
  return (Match_node *)realloc(t,size);
}

void match_tab_m_init_space(Match_node **t,int start,int tab_size,Match_node val){
  int i;

  for(i = start ; i < tab_size ; i++){
    (*t)[i] = val;
  }  
}

void match_tab_m_assign_value(Tab_m *t,int index,Match_node value){
  int size,start;
  if(*t == NULL){
    *t = match_tab_m_init();
  }
  size = ((index/TAB_M_STEP_ALLOC)+1) * TAB_M_STEP_ALLOC;
  start = (*t)->MAX;
  if(index >= (*t)->MAX){
    (*t)->tab = match_tab_m_alloc_space((*t)->tab,size*sizeof(int));
    (*t)->MAX = size;
  }
  if((*t)->tab == NULL) util_error("tab_m_assign_value","allocation of array in Tab_m");  
  match_tab_m_init_space(&((*t)->tab),start,(*t)->MAX,NULL);
  if((*t)->tab[index] == NULL){
    ((*t)->n_elements)++;
  }
  (*t)->tab[index] = value;
}

Match_node match_tab_m_get_value(Tab_m t,int index){
  if(t == NULL) return NULL;
  if(t->MAX <= index){
    return NULL;
  }
  return t->tab[index];
}

int match_tab_m_get_n_elements(Tab_m t){
  if(t == NULL) return 0;
  return t->n_elements;
}
int match_tab_m_get_MAX(Tab_m t){
  if(t == NULL) return 0;
  return t->MAX;
}


Match_node match_get(Match_tree tree,int node_index){
  return match_tab_m_get_value(tree->tree,node_index);
}


int match_add(Match_tree *tree, Match_node node, int parent){
  int n,ni,nc;
  Match_node p;
  char temp[100];

  if(*tree == NULL){
    *tree =  match_init_tree();
    if(*tree == NULL) util_error("match_add","initialization of tree_match");
  }  
  n = match_tab_m_get_n_elements((*tree)->tree);
  match_tab_m_assign_value(&((*tree)->tree),n,node);
  node->parent = parent;
  if(parent < 0){
    ni = tab_i_get_n_elements((*tree)->initiaux);
    tab_i_assign_value(&((*tree)->initiaux),ni,n);
  }
  else{
    p = match_tab_m_get_value((*tree)->tree,parent);
    sprintf(temp,"parent should not be NULL; n_parent=%d",parent);
    if(p == NULL) util_error("match_add",temp);
    nc = tab_i_get_n_elements(p->children);
    tab_i_assign_value(&(p->children),nc,n);
  }
  return n;
}

void match_add_final(Match_tree *tree,int node_index,Match_node node){
  int n = tab_i_get_n_elements((*tree)->finaux);
  node->final = 1;
  tab_i_assign_value2(&((*tree)->finaux),n,node_index,-1);
}


void match_print_unique(Match_tree t,Match_node node){
  int le = 0;
  double w = 1.0;
  Llist l = NULL;
  Llist out = NULL;
  if(node == NULL) return;
  while(node->parent != -1){
    ll_insert(&l,node->match_result,0);
    ll_insert(&out,node->output,0);
    le+=node->length;
    w *= node->weight;
    node = match_tab_m_get_value(t->tree,node->parent);      
  }
  ll_insert(&l,node->match_result,0);
  ll_insert(&out,node->output,0);
  le+=node->length;
  w *= node->weight;
  ll_print_keys(l);
  ll_print_keys(out);
  printf("L=%d\tW=%f\n",le,w);
  ll_free(&l);
  ll_free(&out);
}


void match_print(Match_tree t){
  int n,i,j;
  Match_node node;

  if(t == NULL){
    printf("NO MATCHES\n");
    return;
  }
  n = tab_i_get_n_elements(t->finaux);

  for(i = 0 ; i < n ; i++){
    j = tab_i_get_value(t->finaux,i);
    node = match_tab_m_get_value(t->tree,j);
    match_print_unique(t,node);
  }
}

double match_increment_weight(int calc_type,double w1,double w2){

  switch(calc_type){
  default:
    return w1*w2;
    break;
  }

  return 1.0;
}


int match_find_best(Match_tree t,Match_node *best,int calc_type){
  int l,n,i,index,max,nb;
  double best_weight = 1.0, weight = 1.0;
  Match_node node,temp_node;
  
  if(t == NULL){ 
    *best = NULL;
    return 0;
  }
  n = tab_i_get_n_elements(t->finaux);
  max = 0;
  nb = 0;
  *best = NULL;
  for(i = 0 ; i < n ; i++){
    index = tab_i_get_value(t->finaux,i);
    node = match_tab_m_get_value(t->tree,index);
    temp_node = node;
    l = 0;
    nb = 1;
    while(node->parent != -1){
      l+=node->length;
      weight = match_increment_weight(calc_type,weight,node->weight);
      nb++;
      node = match_tab_m_get_value(t->tree,node->parent);      
    }
    l+=node->length;
    weight = match_increment_weight(calc_type,weight,node->weight);
    if(max <= l){

      if(max == l){
	if(best_weight < weight){
	  max = l;
	  *best = temp_node;
	  best_weight = weight;
	  //	  printf("%f,%d\n",weight,l);
	}	
      }
      else{
	max = l;
	*best = temp_node;
	best_weight = weight;
      }
    }
   
  }
  //    match_print_unique(t,*best);
  return max;
}



void match_free_tab_m(Tab_m *t){
  int n, i;
  Match_node node;

  if(*t == NULL) return;

    n = match_tab_m_get_n_elements(*t);
   for(i = 0 ; i < n ; i++){
     node = match_tab_m_get_value(*t,i);
     tab_i_free(&(node->children));
     match_pfree(node);
   }
   match_pfree((*t)->tab);
   match_pfree(*t);
}


void match_free_tree(Match_tree *tree){
  if(*tree == NULL) return; 
  match_free_tab_m(&((*tree)->tree));
  tab_i_free(&((*tree)->initiaux));
  tab_i_free(&((*tree)->finaux));
  match_pfree(*tree);
}

Syntactic_tree match_to_sa_tree(Match_tree mtree,Match_node node){
  return NULL;
}
