#include <stdio.h>
#include <malloc.h>
#include "llist_t.h"
#include "utilities.h"

int ll_t_n_free = 0;
int ll_t_n_malloc = 0;

void* ll_t_malloc(int n){
  ll_t_n_malloc++;
  return (void *)malloc(n);
}

void ll_t_pfree(void *ptr){
  if(ptr == NULL) return;
  ll_t_n_free++;
  free(ptr);
  ptr = NULL;
}

int ll_t_print_n_malloc(){
  printf("ll_t_malloc=%d\n",ll_t_n_malloc);
  return ll_t_n_malloc;
}

int ll_t_print_n_free(){
  printf("ll_t_free=%d\n",ll_t_n_free);
  return ll_t_n_free;
}


struct ll_t_cell* ll_t_create_cell(unsigned int k,unsigned int v,unsigned int id){
  struct ll_t_cell *ptr = (struct ll_t_cell*)ll_t_malloc(sizeof(struct ll_t_cell));
  ptr->key = k;
  ptr->value = v;
  ptr->id = id;
  ptr->next = NULL;
  return ptr;
}

Llist_t ll_t_initialize(){
  Llist_t ptr = (Llist_t)ll_t_malloc(sizeof(struct linked_list_t));
  ptr->head = NULL;
  ptr->tail = NULL;
  return ptr;
}

void ll_t_insert_at_tail(Llist_t *l,unsigned int k,unsigned int v,unsigned int id){
  struct ll_t_cell *ptr = ll_t_create_cell(k,v,id);

  if(ptr == NULL) util_error("ll_t_insert_at_tail","creating cell");
  if(*l == NULL){
    *l = ll_t_initialize();
  }
  if(*l == NULL)  util_error("ll_t_insert_at_tail","llist initialization");
  if((*l)->head == NULL){
    (*l)->head = ptr;
    (*l)->tail = (*l)->head;
    return;
  }
  (*l)->tail->next = ptr;
  (*l)->tail = (*l)->tail->next;
}


int ll_t_cell_t_compare(struct ll_t_cell *c1,struct ll_t_cell *c2,int option){
  
  if(option == 0){
    return (c1->key < c2->key);
  }
  return (c1->value < c2->value);
}

// No tail

//option = 0 => sorting according to cell keys
//option = 1 => sorting according to cell values

void ll_t_insert_sorted(Llist_t *l,unsigned int k,unsigned int v,unsigned int id,int option){
  struct ll_t_cell* prev, *curr,*temp;
  temp = ll_t_create_cell(k,v,id);
  if(temp == NULL) util_error("ll_t_insert_sorted","creating cell");
  if(*l == NULL){
    *l = ll_t_initialize();
  }
  if(*l == NULL) util_error("ll_t_insert_sorted","llist initialization");

  if ( (*l)->head == NULL ){
    (*l)->head = temp;  
  }
  else{
    prev = NULL;
    curr = (*l)->head;
    
    /* traverse the list until the spot
       for insertion is found */
    while (curr != NULL && ll_t_cell_t_compare(curr,temp,option)){
      prev = curr;
      curr = curr -> next;
    }
    
    /* insert the node, temp */
    if(prev == NULL){
      temp -> next = (*l)->head;
      (*l)->head = temp;
    }
    else{
      prev -> next = temp;
      temp -> next = curr;
    }
  }
}

//find an element in list
//option = 0 => element=key
//option = 1 => element=value

struct ll_t_cell* ll_t_find_element(Llist_t l,int elem,int option){
  struct ll_t_cell *ptr;
  if(l == NULL) return NULL;
  ptr = l->head;
  while(ptr != NULL){
    if(option && (ptr->value == elem)) return ptr;
    if(!option && (ptr->key == elem)) return ptr;
    ptr = ptr->next;
  }
  return NULL;
}

struct ll_t_cell* ll_t_find_element2(Llist_t l,int k,int v){
  struct ll_t_cell *ptr;
  if(l == NULL) return NULL;
  ptr = l->head;
  while(ptr != NULL){
    if((ptr->value == v)&& (ptr->key == k)) return ptr;
    ptr = ptr->next;
  }
  return NULL;
}

void ll_t_print(Llist_t l){
  struct ll_t_cell *ptr;

  if(l == NULL) {
    printf("-- NULL LLIST --\n");
    return;
  }
  ptr = l->head;
  while(ptr != NULL){
    printf("(%d,%d,%d)",ptr->key,ptr->value,ptr->id);
    ptr = ptr->next;
  }
}

void ll_t_println(Llist_t l){
  ll_t_print(l);
  printf("\n");
}


void ll_t_free(Llist_t *l){
  struct ll_t_cell *ptr;

  if(*l != NULL){
    while((*l)->head != NULL){
      ptr = (*l)->head;
      (*l)->head = (*l)->head->next;
      ll_t_pfree(ptr);
    }
    ll_t_pfree(*l);
    *l = NULL;
  }
}


int ll_t_length(Llist_t ll){
  struct ll_t_cell *ptr;
  int i = 0;
  if(ll == NULL) return 0;
  ptr = ll->head;
  while(ptr != NULL){
    ptr = ptr->next;
    i++;
  }
  return i;
}

