#ifndef _h_lex 
#define _h_lex

#include "tree.h"
#include "tab_u.h"
#include "llist_i.h"

#define LEX_NEW_ELEMENT 0
#define LEX_EXISTING_ELEMENT 1

struct lexicon{
  int n_elements;
  Tree_node tree_lexicon;
  Tab_u tab_lexicon;
};

typedef struct lexicon * Lexicon;

int lex_print_n_free();
int lex_print_n_malloc();
Lexicon lex_init();
int lex_add_element(Lexicon *lex,Ustring u);
int lex_add_string_element(Lexicon *lex,char *s);
Tree_node lex_get_tree_root(Lexicon lex);
int lex_add_element2(Lexicon *lex,Ustring u,char *nouvo);
Ustring lex_get_element(Lexicon lex,int index);
Llist_i lex_find_prefixed_elements(Lexicon lex,Ustring prefix);
int lex_get_index(Lexicon lex,Ustring u);
void lex_print(Lexicon lex);
void lex_print_codes(Lexicon lex);
void lex_println(Lexicon lex);
void lex_free(Lexicon *lex);
Tab_u lex_get_tab(Lexicon lex);
#endif

