#include "lexicon.h"
#include "utilities.h"
#include <malloc.h>

int lex_n_free = 0;
int lex_n_malloc = 0;

void* lex_malloc(int n){
  lex_n_malloc++;
  return (void *)malloc(n);
}

void lex_pfree(void *ptr){
  if(ptr == NULL) return;
  lex_n_free++;
  free(ptr);
  ptr = NULL;
}

int lex_print_n_malloc(){
  printf("lex_malloc=%d\n",lex_n_malloc);
  return lex_n_malloc;
}

int lex_print_n_free(){
  printf("lex_free=%d\n",lex_n_free);
  return lex_n_free;
}

Tree_node lex_get_tree_root(Lexicon lex){
  if(lex == NULL) return NULL;
  return lex->tree_lexicon;
}

Llist_i lex_find_prefixed_elements(Lexicon lex,Ustring prefix){
  if(lex == NULL) return NULL;
  return tree_find_prefixed_elements(lex_get_tree_root(lex),prefix);
}

Lexicon lex_init(){
  Lexicon lex =(Lexicon)lex_malloc(sizeof(struct lexicon)); 
  if(lex == NULL) util_error("lex_init","initialization of lexicon");
  lex->n_elements = 0;
  lex->tree_lexicon = tree_init();
  lex->tab_lexicon = NULL;
  return lex;
}

int lex_add_element2(Lexicon *lex,Ustring u, char *nouvo){
  int index;
  if(*lex == NULL){
    *lex = lex_init();
  }
  if((index = tree_word_exists((*lex)->tree_lexicon,u)) == -1){
    tree_insert_word(&((*lex)->tree_lexicon),u,(*lex)->n_elements);
    tab_u_assign_value(&((*lex)->tab_lexicon),(*lex)->n_elements,u);   
    ((*lex)->n_elements)++;    
    *nouvo = LEX_NEW_ELEMENT;
    return  ((*lex)->n_elements) -1 ;
  }  
  *nouvo = LEX_EXISTING_ELEMENT;
  return index;
}


int lex_add_element(Lexicon *lex,Ustring u){
  int index;
  if(*lex == NULL){
    *lex = lex_init();
  }
  if((index = tree_word_exists((*lex)->tree_lexicon,u)) == -1){
    tree_insert_word(&((*lex)->tree_lexicon),u,(*lex)->n_elements);
    tab_u_assign_value(&((*lex)->tab_lexicon),(*lex)->n_elements,u);   
    ((*lex)->n_elements)++;    
    return  ((*lex)->n_elements) -1 ;
  }  
  return index;
}

int lex_add_string_element(Lexicon *lex,char *s){
  Ustring temp = ustring_from_string(s);
  int res;
  if(s == NULL) util_error("lex_add_element","s should not be null");
  res = lex_add_element(lex,temp);
  ustring_free(temp);
  return res;
}


Ustring lex_get_element(Lexicon lex,int index){
  return tab_u_get_value(lex->tab_lexicon,index);
}

int lex_get_index(Lexicon lex,Ustring u){
  return tree_word_exists(lex->tree_lexicon,u);
}


Tab_u lex_get_tab(Lexicon lex){
  if(lex == NULL) return NULL;
  return lex->tab_lexicon;
}

void lex_print(Lexicon lex){
  if(lex == NULL){
    printf("Empty lexicon\n");
    return;
  }
  tab_u_print(lex->tab_lexicon);
}

void lex_print_codes(Lexicon lex){
   if(lex == NULL){
    printf("Empty lexicon\n");
    return;
   }
   tab_u_print_codes(lex->tab_lexicon);
}


void lex_println(Lexicon lex){
  lex_print(lex);
}


void lex_free(Lexicon *lex){
  tab_u_free(&((*lex)->tab_lexicon));
  tree_free(&((*lex)->tree_lexicon));
  lex_pfree(*lex);
}
