#ifndef _h_hash 
#define _h_hash


#include "llist_t.h"
#include "llist_i.h"

struct hashtable{
  int length;
  Llist_t *table;
};

typedef struct hashtable * Hashtable;

//FUNCTIONS

Hashtable hash_init(int l);
void hash_add_element(Hashtable *ht,int key,int value,int id);
int hash_get_value(Hashtable ht,int key);
Llist_i hash_get_keys(Hashtable ht);
int hash_get_id(Hashtable ht,int key,int value);
void hash_free(Hashtable ht);
int hash_print_n_malloc();
int hash_print_n_free();
void hash_println(Hashtable ht);
void hash_print(Hashtable ht);

#endif
