#ifndef _h_gram
#define _h_gram

#include "automata.h"
#include "tab_u.h"
#include "lexicon.h"

#define GRAM_STEP_ALLOC 32

//structure of a grammar

struct grammar{
  int n_automata; //number of automata
  int n_terminals;
  Lexicon graph_names;
  Tab_u terminals;
  Automaton *automata; //array of automata; first one, is the main automaton
  int MAX;
};

typedef struct grammar * Grammar;



//FUNCTIONS

Grammar gram_init();
void gram_add_automaton(Grammar *gram,int index,Automaton aut);
Automaton gram_get_automaton(Grammar gram,int index);
void gram_add_terminal(Grammar *gram,int index,Ustring terminal);
void gram_add_graph_name(Grammar *gram,int index,Ustring grf);
Tab_u gram_get_terminals(Grammar gram);
Lexicon gram_get_graph_names(Grammar gram);
int gram_get_graph_name_index(Grammar gram,Ustring grf);
int gram_print_n_malloc();
int gram_print_n_free();
void gram_free(Grammar *);
void gram_print(Grammar gram,int option);
void gram_println(Grammar gram,int option);
int gram_get_n_automata(Grammar gram);
int gram_get_n_terminals(Grammar gram);
void gram_set_n_terminals(Grammar gram,int n);
void gram_change_morpho_terminals(Grammar *gram);


#endif
