#include <malloc.h>
#include "grammar.h"
#include "utilities.h"

int gram_n_free = 0;
int gram_n_malloc = 0;

void* gram_malloc(int n){
  gram_n_malloc++;
  return (void *)malloc(n);
}

void gram_pfree(void *ptr){
  if(ptr == NULL) return;
  gram_n_free++;
  free(ptr);
  ptr = NULL;
}

int gram_print_n_malloc(){
  printf("gram_malloc=%d\n",gram_n_malloc);
  return gram_n_malloc;
}

int gram_print_n_free(){
  printf("gram_free=%d\n",gram_n_free);
  return gram_n_free;
}

Grammar gram_init(){
  Grammar gram;

  gram = (Grammar)gram_malloc(sizeof(struct grammar));
  if(gram == NULL) util_error("gram_init_grammar","allocation of new grammar");
  
  gram->n_automata = 0;
  gram->n_terminals = 0;
  gram->MAX = 0;
  gram->automata = NULL;
  gram->graph_names = lex_init();
  gram->terminals = NULL;

  return gram;
}

Automaton* gram_automata_allocation(Grammar *gram,int min_size){
  int start,i;
  if(*gram == NULL) util_error("gram_automata_allocation","*gram is NULL");
  if(min_size <= (*gram)->MAX) return (*gram)->automata;
  
  start = (*gram)->MAX;
  (*gram)->MAX = ((min_size/AUTO_STEP_ALLOC)+1)*AUTO_STEP_ALLOC; 
  if((*gram)->automata == NULL) 
    (*gram)->automata = (Automaton *)gram_malloc((*gram)->MAX * sizeof(Automaton));
  else (*gram)->automata = (Automaton *)realloc(*gram,(*gram)->MAX * sizeof(Automaton));
  if((*gram)->automata == NULL) util_error("gram_automata_allocation","allocation of *gram");
  
  //initialization of each state to NULL
  for(i = start ; i < (*gram)->MAX ; i++){
    (*gram)->automata[i] = NULL;
  }
  return (*gram)->automata;
}


void gram_add_automaton(Grammar *gram,int index,Automaton aut){
  if(*gram == NULL){
    *gram = gram_init();
  }
  (*gram)->automata =  gram_automata_allocation(gram,index + 1);
  if((*gram)->automata[index] != NULL){
    auto_free(&((*gram)->automata[index]));
  }
  else{
    ((*gram)->n_automata)++;
  }
  (*gram)->automata[index] = aut;
}

Automaton gram_get_automaton(Grammar gram,int index){
  if(gram == NULL) return NULL;
  if(index >= gram->MAX) return NULL;
  return gram->automata[index];
}

Tab_u gram_get_terminals(Grammar gram){
  if(gram == NULL) return NULL;
  return gram->terminals;
}

Lexicon gram_get_graph_names(Grammar gram){
  if(gram == NULL) return NULL;
  return gram->graph_names;
}

void gram_add_graph_name(Grammar *gram,int index,Ustring grf){
  if(*gram == NULL) util_error("gram_add_graph_name","*gram is NULL");
  lex_add_element(&((*gram)->graph_names),grf);
}

int gram_get_graph_name_index(Grammar gram,Ustring grf){
  if(gram == NULL) util_error("gram_get_graph_name_index","gram should not be null");
  return lex_get_index(gram->graph_names,grf);
}

void gram_add_terminal(Grammar *gram,int index,Ustring terminal){
  if(*gram == NULL) util_error("gram_add_terminal","*gram is NULL");
  tab_u_assign_value(&((*gram)->terminals),index,terminal);
}

void gram_change_morpho_terminals_trans(Transitions *trans,Tab_u terminals){
  int i;
  Uchar c;
  Ustring u;

  if(*trans == NULL) return;

  for(i = 0 ; i < (*trans)->n_transitions ; i++){
    if(tab_i_get_value((*trans)->input_tags,i) == 0){
      c = 0;
    }
    else{
      u = tab_u_get_value(terminals,tab_i_get_value((*trans)->input_tags,i));
      c = ustring_get_uchar(u,0);
    }
    tab_i_assign_value(&((*trans)->input_tags),i,c);
  }
  /*  keys = tab_i_sort2(temp,0); //Bug
  
  for(i = 0 ; i < (*trans)->n_transitions ; i++){
    ki = tab_i_get_value(keys,i);
    tab_i_assign_value(&input,i,tab_i_get_value(temp,ki));
    tab_i_assign_value(&output,i,tab_i_get_value((*trans)->output_tags,ki));
    tab_d_assign_value(&weights,i,tab_d_get_value((*trans)->weights,ki));
    }
  //tab_i_println((*trans)->input_tags);  
  tab_i_free(&((*trans)->input_tags));
  (*trans)->input_tags = input;
  //printf("\n");
  tab_i_free(&((*trans)->output_tags));
  (*trans)->output_tags = output;
  //tab_i_println((*trans)->output_tags);
  tab_d_free(&((*trans)->weights));
  (*trans)->weights = weights;
  tab_i_free(&keys);
  tab_i_free(&temp);*/
}


void gram_change_morpho_terminals_auto(Automaton *aut,Tab_u terminals){
  int i,n_states;
  n_states = (*aut)->n_states;
  for(i = 0 ; i < n_states ; i++){
    gram_change_morpho_terminals_trans(&((*aut)->states[i]->terminal_trans),terminals);
  }
}

void gram_change_morpho_terminals(Grammar *gram){
  Automaton aut = NULL;
  int n = gram_get_n_automata(*gram);
  int i;

  for(i = 0 ; i < n ; i++){
    aut = gram_get_automaton(*gram,i);
    if(aut == NULL) return;
    gram_change_morpho_terminals_auto(&aut,(*gram)->terminals);
  }
}

void gram_free(Grammar *gram){
  int i,n;
  if(*gram == NULL) return;
  n = (*gram)->n_automata;
  for(i = 0 ; i < n ; i++){
    auto_free(&((*gram)->automata[i]));
  }
  tab_u_free(&((*gram)->terminals));
  lex_free(&((*gram)->graph_names));
  gram_pfree((*gram)->automata);
  gram_pfree(*gram);
}

int gram_get_n_automata(Grammar gram){
  if(gram == NULL) return 0;
  return gram->n_automata;
}


int gram_get_n_terminals(Grammar gram){
  if(gram == NULL) return 0;
  return gram->n_terminals;
}

void gram_set_n_terminals(Grammar gram,int n){
  if(gram == NULL) util_error("gram_set_n_terminals","gram is NULL");
  gram->n_terminals = n;
}


//option = 0; not display ouputs of automata

void gram_print(Grammar gram,int option){
  int i;
  Tab_u temp;

  if(gram == NULL){
    printf("Grammar = empty\n");
    return;
  }
  printf("@@@@@@ GRAMMAR @@@@@@\n");
  temp = lex_get_tab(gram->graph_names);
  for(i = 0 ; i < gram->n_automata ; i++){
    printf("Automaton %d:",i);
    ustring_println(tab_u_get_value(temp,i));
    auto_print(gram->automata[i],option);
  }
  printf("terminals=\n");
  tab_u_println(gram->terminals);
  printf("@@@@@@ @@@@@@ @@@@@@\n");
}

void gram_println(Grammar gram,int option){
  gram_print(gram,option);
}
