#ifndef _h_fst2 
#define _h_fst2
#include "grammar.h"
#include "tree.h"
#include "tab_u.h"
#include "tab_i.h"
#include "tab_d.h"
#include "tab_l.h"
#include "tokens.h"

#define FST2_INTEX_FORMAT 1
#define FST2_UNITEX_FORMAT 0

//Structures
struct fst2_context{
  Tab_u graph_names;
  Tab_u terminals;
  Tab_u tags;
  Tab_l tag_analyses;
  Tab_i inputs;
  Tab_i outputs;
  Tab_d weights;
  Tree_node tree_names;
  Tree_node tree_terminals;
  int n_automata;
  int n_terminals;
  int n_tags;
  int option; //unitex format ; intex format
};


//functions
Grammar fst2_load_graph(char *name,int is_intex_format, Tokens *tok);
int fst2_print_n_free();
int fst2_print_n_malloc();
#endif
