#ifndef _h_a2t 
#define _h_a2t

#include "tab_i.h"
#include "tab_d.h"
#include "tab_u.h"
#include "text.h"
#include "grammar.h"
#include "match.h"
#include "stack_f.h"
#include "tokens.h"
#include "analysis.h"
#include "tab_l.h"
#include "dico.h"
#include "alphabet.h"

#define A2T_FREE_TOKENS 1
#define A2T_NOT_FREE_TOKENS 0
#define A2T_FREE_RESULT_TEXT 1
#define A2T_NOT_FREE_RESULT_TEXT 0

struct a2t_context{
  int application; // 0: tokenization
  int max_descriptors;
  int out_fd[10]; //file descriptors for outing (array of max length 10)
  Tab_i inverse_char;
  int n_text_buffers;
  int parsing_type; //0: morphological parsing (tokenizing) ; ...
  Text *text_buffers;
  int weight_calculus; //0: multiplication; 1: addition
  Grammar grammar; //parsing grammar
  Match_tree parsing_tree;
  Tokens tokens; // tokens
  Analyses ana_outputs; //output analysis
  int output_header;
  Tab_l graph_features;
  Dico dico;
  Alphabet alphabet;
};

struct a2t_local_context{
  int current_text_buffer;
  int text_position;
  int current_state;
  int current_automaton;
  int current_parent;
  char reached;
  Stack_f current_stack;

};

struct a2t_result{
  Text new_text;
  Tokens tokens;
  Tab_l tok_features;
};


// Functions

int a2t_print_n_malloc();
int a2t_print_n_free();
void a2t_add_text_buffer(struct a2t_context * context,Text buffer);
Tab_i a2t_get_inverse_uchar(Tab_u tab);
void a2t_free_context(struct a2t_context *c,int option);
Tab_u a2t_apply_automaton(struct a2t_context *context);
Tab_u a2t_apply_grammar(struct a2t_context *context,struct a2t_result *result);
int a2t_apply_grammar_rec(int start,struct a2t_context *context,struct a2t_local_context local);
void a2t_init_context(struct a2t_context *context,Tokens *tok,Grammar g,int calc_type,Text t,int parsing_type,int application,int out_fd[],int max,char *config_file,Dico dic,Alphabet alph);
int a2t_graph_feature_is_displayed(struct a2t_context *context,int grf);
void a2t_free_result(struct a2t_result *result,int free_text);
void a2t_init_result(struct a2t_result *result);
#endif
