#include "auto2txt.h"
#include "applications.h"
#include <malloc.h>
#include <stdio.h>
#include "utilities.h"
#include "match.h"

int a2t_n_free = 0;
int a2t_n_malloc = 0;

void* a2t_malloc(int n){
  a2t_n_malloc++;
  return (void *)malloc(n);
}

void a2t_pfree(void *ptr){
  if(ptr == NULL) return;
  a2t_n_free++;
  free(ptr);
  ptr = NULL;
}

int a2t_print_n_malloc(){
  printf("a2t_malloc=%d\n",a2t_n_malloc);
  return a2t_n_malloc;
}

int a2t_print_n_free(){
  printf("a2t_free=%d\n",a2t_n_free);
  return a2t_n_free;
}

void a2t_get_graph_output_configuration(struct a2t_context *context,Ustring u){
    int k,v,grf;
    int i;
    int l;
    Ustring head,temp,feature;
    Tab_u t = NULL,t2 = NULL,t3 = NULL;
  
    //   ustring_println(u);
    t = ustring_split((Uchar)':',u);
    head = tab_u_get_value(t,0);
    temp = tab_u_get_value(t,1);
    grf = gram_get_graph_name_index(context->grammar,head);
    t2 = ustring_split((Uchar)';',temp);
    l = tab_u_get_n_elements(t2);
    for(i = 0 ; i < l ; i++){
      feature = tab_u_get_value(t2,i);
      t3 = ustring_split((Uchar)'=',feature);
      tok_add_element(&(context->tokens),tab_u_get_value(t3,0),0,&k);
      tok_add_element(&(context->tokens),tab_u_get_value(t3,1),0,&v);
      tab_l_insert_value(&(context->graph_features),grf,k,v);
      tab_u_free(&t3);
    }
    tab_u_free(&t2);
    tab_u_free(&t);
}

int a2t_graph_feature_is_displayed(struct a2t_context *context,int grf){
  if(tab_l_get_list(context->graph_features,grf) == NULL) return 0;
  return 1;
}


void a2t_get_header_output_configuration(struct a2t_context *context,Ustring u){
   Ustring type,head;
   Tab_u t = NULL;
   
   t = ustring_split((Uchar)'=',u);
   head = tab_u_get_value(t,0);
   type = tab_u_get_value(t,1);
   tok_add_element(&(context->tokens),type,0,&(context->output_header));
   tab_u_free(&t);   
}

void a2t_get_output_configuration(struct a2t_context *context,char *output_config){
  Ustring u;
  FILE *f;
  //put graph names in context->lexicon
  
  f = fopen(output_config,"r");
  if(f == NULL) util_error("a2t_get_grammar_outputs","cannot open config");
  u = ustring_get_line(f,1);
  ustring_free(u);
  u = ustring_get_line(f,1);
  a2t_get_header_output_configuration(context,u);
  ustring_free(u);
  while((u = ustring_get_line(f,1)) != NULL){
    a2t_get_graph_output_configuration(context,u);
    ustring_free(u);
  }
  fclose(f);
}


void a2t_init_context(struct a2t_context *context,Tokens *tok,Grammar g,int calc_type,Text t,int parsing_type,int application,int out_fd[],int max, char *config_file,Dico dic,Alphabet alph){
  int i;

  context->max_descriptors = max;
  for(i = 0 ; i < 10 ; i++){
    out_fd[i] = -1;
  }

  for(i = 0 ; i < max ; i++){
    context->out_fd[i] = out_fd[i];
  }
  context->application = application;
  context->n_text_buffers = 0;
  context->inverse_char = NULL;
  context->text_buffers = NULL;
  a2t_add_text_buffer(context,t);
  context->parsing_type = parsing_type;
  context->weight_calculus = calc_type;
  context->parsing_tree = NULL;
  context->grammar = g;
  if(tok == NULL) tok_init(&(context->tokens));
  else tok_assign(&(context->tokens),*tok);
  context->graph_features = NULL;
  context->ana_outputs = ana_get_grammar_outputs(gram_get_terminals(g), &(context->tokens)); 
  a2t_get_output_configuration(context,config_file);
  context->alphabet = alph;
  context->dico = dic;
}


void a2t_add_text_buffer(struct a2t_context * context,Text buffer){
  int n;
  n = context->n_text_buffers;
  if(context->text_buffers == NULL){
    context->text_buffers = (Text *)a2t_malloc((n+1)*sizeof(Text));
  }
  else{
    context->text_buffers = (Text *)realloc(context->text_buffers,(n+1)*sizeof(Text));
  }
  context->text_buffers[n] = buffer;
  (context->n_text_buffers)++;
}


void a2t_init_result(struct a2t_result *result){
  result->new_text = NULL;
  tok_init(&(result->tokens));
  result->tok_features = NULL;
} 

void a2t_free_result(struct a2t_result *res,int free_result_text){
  if(free_result_text) txt_free(&(res->new_text));
  tok_free(&(res->tokens));
  tab_l_free(&(res->tok_features));
}


Tab_i a2t_get_inverse_uchar(Tab_u tab){
  Tab_i temp = NULL;
  Ustring u;
  int i,n,c;

  if(tab == NULL) return NULL;
  n = tab_u_get_n_elements(tab);

  for(i = 0 ; i < n ; i++){
    u = tab_u_get_value(tab,i);
    c = ustring_get_uchar(u,0);
    //pb: empty terminal ("")
    // probably comes from transducer
    //tab_i_assign_value2(&temp,ustring_get_uchar(u,0),i,-1);
  }

  return temp;
}

//option = 0 ; we don't free tokens
//option = 1 ; we free tokens

void a2t_free_context(struct a2t_context *c,int free_tokens){
  int i,n;
  tab_i_free(&(c->inverse_char));
  for(i = 0 ; i < c->n_text_buffers ; i++){
    txt_free(&(c->text_buffers[i]));
  }
  n = tab_u_get_n_elements(gram_get_terminals(c->grammar));
  ana_free_output(&(c->ana_outputs));
  a2t_pfree(c->text_buffers);
  gram_free(&(c->grammar));
  match_free_tree(&(c->parsing_tree));
  if(free_tokens) tok_free(&(c->tokens));
  tab_l_free(&(c->graph_features));
  alph_free(&(c->alphabet));
  dico_free(&(c->dico));
}

Match_node a2t_morpho_matching(int tag,int pos,Text texte,int output,double weight){
  Match_node node = NULL;

  if(tag == txt_get_element(texte,pos)){
    node = match_create(1,tag,output,weight,NULL,NULL);    
  }
  return node;
}

//match between two linguistic elements => intersection
//<N> vs. avions = avions,avion.N:mp
//<V> vs. avions = avions,avoir.V:I1p

Match_node a2t_matching(int tag,int pos,Text texte,int type,int output,double weight){
  switch(type){
    // morphological analysis
  case 0: 
    return a2t_morpho_matching(tag,pos,texte,output,weight);
    break;
  default:
    return NULL;
    break;
  }
}


void a2t_init_local_context(struct a2t_local_context * local,int text_buffer,int text_pos,int state,int aut,int parent,Stack_f stack){
  local->current_text_buffer = text_buffer;
  local->text_position = text_pos;
  local->current_state = state;
  local->current_automaton = aut;
  local->current_parent = parent;
  local->current_stack = stack;
  local->reached = 0;
}

void a2t_local_context_set_reached(struct a2t_local_context *local,char reached){
  local->reached = reached;
}

char a2t_state_is_reached_by_epsilon_trans(struct a2t_local_context local){
  return (local.reached & 2);
}


char a2t_state_is_reached_by_aux_trans(struct a2t_local_context local){
  return (local.reached & 1);
}


void a2t_free_local_context(struct a2t_local_context *local){
  stack_f_free(&(local->current_stack));
}


void a2t_print_local_context(struct a2t_local_context local){
  printf("****************\n");
  printf("pos=%d\n",local.text_position);
  printf("automaton=%d\tstate=%d\n",local.current_automaton,local.current_state);
  stack_f_print(local.current_stack);
  printf("****************\n");
}



int a2t_apply_automaton_rec(int start,struct a2t_context *context,struct a2t_local_context local){  
  int position = start,i,fils;
  Match_node node;
  Text texte = context->text_buffers[local.current_text_buffer];
  Automaton aut = gram_get_automaton(context->grammar,local.current_automaton);
  State current = auto_get_state(aut,local.current_state);
  if(current == NULL) return -1;
  State child;
  struct a2t_local_context local2;
  Transitions tr = auto_get_terminal_transitions(current);
  int n = auto_get_n_transitions(tr);
  int tag,arr,output;
  double weight;

  for(i = 0 ; i < n ; i++){
    tag = tab_i_get_value(tr->input_tags,i);
    arr = tab_i_get_value(tr->arr,i);
    weight = tab_d_get_value(tr->weights,i);
    output = tab_i_get_value(tr->output_tags,i);
    if((node = a2t_matching(tag,local.text_position,texte,context->parsing_type,output,weight))!= NULL){      
      fils = match_add(&(context->parsing_tree),node,local.current_parent);      
      a2t_init_local_context(&local2,local.current_text_buffer,local.text_position + node->length,arr,local.current_automaton,fils,NULL);
      a2t_apply_automaton_rec(start,context,local2);
      child = auto_get_state(aut,arr);
       if(auto_is_final_state(child)){
	 match_add_final(&(context->parsing_tree),fils,node);
       }
    }
  }

  return position;
}


//type = 0 => morphological graph application

Tab_u a2t_apply_automaton(struct a2t_context *context){
  Tab_u tu = NULL;
  struct a2t_local_context local;
  Match_node node;
  int step,n;

  int pos,start,cnt;
  pos = 0;
  cnt = 0;

  a2t_init_local_context(&local,0,0,0,0,-1,NULL);
  Text texte = context->text_buffers[0];
  n = txt_get_length(texte);
  while(local.text_position < n){
    
    context->parsing_tree = NULL;
    start = local.text_position;
    a2t_apply_automaton_rec(start,context,local);

    step = match_find_best(context->parsing_tree,&node,0);
    match_print_unique(context->parsing_tree,node);
    match_free_tree(&(context->parsing_tree));
    context->parsing_tree = NULL;
    if(step == 0) (local.text_position)++;
    else local.text_position += step;   
  }

  return tu;
}

int a2t_terminal_is_empty_word(int tag){
  return (tag == 0);
}



//When a final state is reached, we whenever possible (stack not empty) we go back in an upper graph (the graph that contained the call to the current graph)

void a2t_go_to_upper_automaton(int start, struct a2t_context *context, int parent, struct a2t_local_context local,int match_length){
  Match_node temp_node;
  Stack_f stack;
  int fils;
  struct stack_f_element *elem;
  struct a2t_local_context local2;

  temp_node = match_create(0,0,-1,1.00,NULL,NULL);
  match_set_subauto_close(temp_node,local.current_automaton);
  fils = match_add(&(context->parsing_tree),temp_node,parent);
  stack = stack_f_copy(local.current_stack);
  elem = stack_f_pull(&stack);
  a2t_init_local_context(&local2,local.current_text_buffer,local.text_position + match_length,stack_f_get_state(*elem),stack_f_get_automaton(*elem),fils,stack);
  a2t_local_context_set_reached(&local2,1);
  a2t_apply_grammar_rec(start,context,local2);      
  stack_f_free_element(&elem);
  stack_f_free(&stack);
}


int a2t_apply_grammar_rec(int start,struct a2t_context *context,struct a2t_local_context local){  
  int position = start,i,fils;
  Match_node node,temp_node;
  Text texte = context->text_buffers[local.current_text_buffer];
  Automaton aut = gram_get_automaton(context->grammar,local.current_automaton);
  State current = auto_get_state(aut,local.current_state);
  if(current == NULL) return -1;
  State child;
  struct a2t_local_context local2;
  Transitions tr = auto_get_terminal_transitions(current);
  Transitions aux = auto_get_auxiliary_transitions(current);
  int n = auto_get_n_transitions(tr);
  int tag,arr,output;
  double weight;
  Stack_f stack = NULL;

  //Case where current state is reached by auxiliary transition and is final : if possible, need for going up in the super automaton (non empty stack) else sequence is recognized (empty stack = main automaton)

  if(auto_is_final_state(current) && (a2t_state_is_reached_by_aux_trans(local) || a2t_state_is_reached_by_epsilon_trans(local))){

    if(!stack_f_is_empty(local.current_stack)){            
      a2t_go_to_upper_automaton(start,context,local.current_parent, local,0);   
    }
    else{
        temp_node = match_create(0,0,-1,1.00,NULL,NULL);
	fils = match_add(&(context->parsing_tree),temp_node,local.current_parent);
	match_add_final(&(context->parsing_tree),fils,temp_node);
    }
  }

    //parcours des transitions terminales
  for(i = 0 ; i < n ; i++){
    tag = tab_i_get_value(tr->input_tags,i);
    arr = tab_i_get_value(tr->arr,i);
    weight = tab_d_get_value(tr->weights,i);
    output = tab_i_get_value(tr->output_tags,i);
    if((node = a2t_matching(tag,local.text_position,texte,context->parsing_type,output,weight))!= NULL){            //match entre terminal et element du texte
      fils = match_add(&(context->parsing_tree),node,local.current_parent);      
      child = auto_get_state(aut,arr);
      a2t_init_local_context(&local2,local.current_text_buffer,local.text_position + node->length,arr,local.current_automaton,fils,local.current_stack);
      a2t_apply_grammar_rec(start,context,local2); 
       if(auto_is_final_state(child)){
	 if(stack_f_is_empty(local.current_stack)){ 
	   match_add_final(&(context->parsing_tree),fils,node);
	 }
	 else{	   
	   a2t_go_to_upper_automaton(start,context,fils,local,node->length);
	 }
       }
    }
    else{//si ca match pas
      if(a2t_terminal_is_empty_word(tag)){ // if the tag is epsilon we move in the automaton but not in the text
	//we also add a match_node in case that there is an output
	node = match_create(0,0,output,weight,NULL,NULL);
	fils = match_add(&(context->parsing_tree),node,local.current_parent);
	a2t_init_local_context(&local2,local.current_text_buffer,local.text_position,arr,local.current_automaton,fils,local.current_stack);	
	a2t_local_context_set_reached(&local2,2);
	a2t_apply_grammar_rec(start,context,local2); 
      }
    }    
  }
  //parcours des transitions auxiliaires
  n = auto_get_n_transitions(aux);
  for(i = 0 ; i < n ; i++) 
  {
     tag = tab_i_get_value(aux->input_tags,i);
     arr = tab_i_get_value(aux->arr,i);
     stack = stack_f_copy(local.current_stack);
     stack_f_push(&stack,local.current_automaton,arr);
     temp_node = match_create(0,0,-1,1.00,NULL,NULL);
     match_set_subauto_open(temp_node,tag);
     fils = match_add(&(context->parsing_tree),temp_node,local.current_parent);
     a2t_init_local_context(&local2,local.current_text_buffer,local.text_position,0,tag,fils,stack);
     a2t_apply_grammar_rec(start,context,local2);
     stack_f_free(&stack);
  }

  return position;
}



Tab_u a2t_apply_grammar(struct a2t_context *context,struct a2t_result *result){
  Tab_u tu = NULL;
  struct a2t_local_context local;
  Match_node node;
  int step,n;

  int pos,start,cnt;
  pos = 0;
  cnt = 0;

  a2t_init_local_context(&local,0,0,0,0,-1,NULL);
  Text texte = context->text_buffers[0];
  n = txt_get_length(texte);
  while(local.text_position < n){
    
    context->parsing_tree = NULL;
    start = local.text_position;
    a2t_apply_grammar_rec(start,context,local);
    step = match_find_best(context->parsing_tree,&node,0);    
    app_process(context,result,node);
    match_free_tree(&(context->parsing_tree));
    context->parsing_tree = NULL;
    if(step == 0) (local.text_position)++;
    else local.text_position += step;   
  }

  return tu;
}
