#include "applications.h"
#include "llist.h"
#include "ustring.h"
#include "stack_f.h"
#include <malloc.h>
#include <stdio.h>
#include "tab_l.h"
#include "utilities.h"

int app_n_free = 0;
int app_n_malloc = 0;

void* app_malloc(int n){
  app_n_malloc++;
  return (void *)malloc(n);
}

void app_pfree(void *ptr){
  if(ptr == NULL) return;
  app_n_free++;
  free(ptr);
  ptr = NULL;
}

int app_print_n_malloc(){
  printf("app_malloc=%d\n",app_n_malloc);
  return app_n_malloc;
}

int app_print_n_free(){
  printf("app_free=%d\n",app_n_free);
  return app_n_free;
}

int app_is_variable(Lexicon lex,int index){
  Ustring u = lex_get_element(lex,index);
  Ustring v = ustring_from_string("$$");
  int res = ustring_cmp(u,v);
  ustring_free(v);
  if(res) return 0;
  return 1;
}

int app_is_function(Tokens tokens,int index){
  Ustring u;
  int res;

  u = tok_get_element(tokens,index);
  u = ustring_get_function(u);
  if(u == NULL) return -1;
  res = tok_exists(tokens,u);
  ustring_free(u);
  return res;
}

int app_add_terminal(Syntactic_tree *sa_tree,int current_node,int unit,struct a2t_context *context){
  Syntactic_node node = sa_create_node();
  int terminal_node = sa_add_tree_node(sa_tree,node);  
  sa_add_tree_transition(sa_tree,current_node,terminal_node);
  sa_set_node_pattern(&node,unit);


  //ADD THE FEATURES

  return terminal_node;
}

void app_add_graph_features(Syntactic_tree *sa_tree,int current_node, Tab_l features,int grf){
  Llist ll;
  struct ll_cell *ptr;
  Syntactic_node node;
  
  ll = tab_l_get_list(features,grf);
  node = sa_get_tree_node(*sa_tree,current_node);
  if(ll != NULL){
    ptr = ll->head;
    while(ptr != NULL){
      sa_add_node_feature(&node,ptr->key,ptr->value);
      ptr = ptr->next;
    }
  }  
}

void app_in_graph_sa_processing(struct a2t_context *context,int ngrf,Syntactic_tree *sa_tree,
				 int *temp_node,int *current_node,Stack_f *stack){
   if((ngrf >= 0) && (a2t_graph_feature_is_displayed(context,ngrf))){      
      *temp_node = sa_add_tree_node(sa_tree,sa_create_node());
      app_add_graph_features(sa_tree,*temp_node,context->graph_features,ngrf);
      if(*current_node != -1){
	stack_f_push(stack,*current_node,-1);
	sa_add_tree_transition(sa_tree,*current_node,*temp_node);
      }
      *current_node = *temp_node;
    }
}


void app_out_graph_sa_processing(struct a2t_context *context,int egrf,int *last_node,
				 int *current_node,Stack_f *stack){
    struct stack_f_element* element;

     if((egrf >= 0) && (a2t_graph_feature_is_displayed(context,egrf))){
       element = stack_f_pull(stack);
       *last_node = *current_node;
       if(element != NULL){
	 *current_node = stack_f_get_current(*element);
	 stack_f_free_element(&element);
       }
     }
}

void app_terminal_symbol_sa_processing(int terminal,int *terminal_node,int *last_node,int current_node,
				       Syntactic_tree *sa_tree,struct a2t_context *context){
  
     if(terminal > 0){
       *terminal_node = app_add_terminal(sa_tree,current_node,terminal,context);
       *last_node = *terminal_node;
     }     
}

void app_features_sa_processing(int output,Syntactic_tree sa_tree,int current_node,int last_node,
				struct a2t_context *context){
    Syntactic_node node;
    int val,f_key;
    struct ll_cell* ptr;
    Llist l_out;

    node = sa_get_tree_node(sa_tree,current_node);
    if(output != -1){
      l_out = ana_get_analysis_list(context->ana_outputs,output);
      //   printf("==%d",output);
      //ll_println(l_out);
      if(l_out != NULL){
	ptr = l_out->head;
	while(ptr != NULL){
	  //printf("#%d#",ptr->value);
	  val = ptr->value;
	  if(app_is_variable(tok_get_lexicon(context->tokens),ptr->value)){
	    val = -last_node - 1;
	    //  printf("{%d}",last_node);
	  }
	  else{
	    if((f_key = app_is_function(context->tokens,ptr->value)) != -1 ){
	      val = sa_get_feature_value(sa_tree,f_key,last_node);
	    }
	  }
	  sa_add_node_feature(&node,ptr->key,val);
	  ptr = ptr->next;
	}
      }
    }
}



void app_syntactic_analysis(struct a2t_context *context,Llist result,Llist output,Llist newGrf,Llist endGrf){
  int terminal,out,ngrf,egrf,current_node,terminal_node,temp_node,last_node;
  struct ll_cell *ptr1,*ptr2,*ptr3,*ptr4;
  Stack_f stack = NULL;
  Syntactic_tree sa_tree;


  current_node = -1;
  last_node = -1;
  sa_init_tree2(&sa_tree);

  if((result == NULL) || (output == NULL) || (newGrf == NULL) || (endGrf == NULL)) return;
  ptr1 = result->head;
  ptr2 = output->head;
  ptr3 = newGrf->head;
  ptr4 = endGrf->head;

  while((ptr1 != NULL) && (ptr2 != NULL) && (ptr3 != NULL) && (ptr4 != NULL)){
    terminal = ptr1->key;
    out = ptr2->key;
    ngrf = ptr3->key;
    egrf = ptr4->key;

    //we're entering a new graph
    app_in_graph_sa_processing(context,ngrf,&sa_tree,&temp_node,&current_node,&stack);

    //we're exiting a graph
    app_out_graph_sa_processing(context,egrf,&last_node,&current_node,&stack);

    //we have a terminal symbol
    app_terminal_symbol_sa_processing(terminal,&terminal_node,&last_node,current_node,&sa_tree,context);

    // features
    app_features_sa_processing(out,sa_tree,current_node,last_node,context);
    
    ptr1 = ptr1->next;
    ptr2 = ptr2->next;
    ptr3 = ptr3->next;
    ptr4 = ptr4->next;
  }

  sa_print_tree(sa_tree,tok_get_lexicon(context->tokens),context->output_header);
  sa_free_tree(&sa_tree);
}

void app_insert_features_in_list(Analyses ana_outputs,int index,Llist *l){
  struct ll_cell *ptr;
  
  Llist ana = ana_get_analysis_list(ana_outputs,index);
  if(ana == NULL) return;
  ptr = ana->head;
  while(ptr != NULL){
    ll_insert_sorted(l,ptr->key,ptr->value,0);
    ptr = ptr->next;
  }
}


void app_tokenization(struct a2t_context *context, Llist tok, Llist output,struct a2t_result *result){  
  Ustring temp = NULL;
  Ustring temp2 = NULL,u;
  int index;
  Llist temp_ll = NULL;
  struct ll_cell *ptr1,*ptr2;

  if(tok == NULL) return;
  ptr1 = tok->head;
  ptr2 = output->head;
  while((ptr1 != NULL) && (ptr2 != NULL)){
    if(ptr1->key != 0){
      ustring_append(&temp,ptr1->key);      
    }
    if(ptr2->key != -1){
      u = ana_to_ustring(context->ana_outputs,ptr2->key,context->tokens);
      app_insert_features_in_list(context->ana_outputs,ptr2->key,&temp_ll);
      ustring_strcat(&temp2,u);
      ustring_free(u);
    }
    ptr1 = ptr1->next;
    ptr2 = ptr2->next;
  }
  ustring_append(&temp2,(int)'\n');
  if(tok_add_element(&(context->tokens),temp,1,&index)){
    if(context->max_descriptors > 0){
      ustring_write(1,temp);
      ustring_write(1,temp2);
    }
  }
  tab_l_set_list(&(result->tok_features),index,temp_ll);  
  txt_append_element(&(result->new_text),index);  
  ustring_free(temp);
  ustring_free(temp2);  
}


void app_process(struct a2t_context *context,struct a2t_result *result,Match_node node){
  int length = 0;
  double weight = 1.0;  

  Llist terminals = NULL;
  Llist output = NULL;
  Llist newGrf = NULL;
  Llist endGrf = NULL;


  if(node == NULL) return;
  while(node->parent != -1){
    ll_insert(&terminals,node->match_result,0);
    ll_insert(&output,node->output,0);
    ll_insert(&newGrf,node->subauto_open,0);
    ll_insert(&endGrf,node->subauto_close,0);
    length+=node->length;
    weight *= node->weight;
    node = match_tab_m_get_value((context->parsing_tree)->tree,node->parent);      
  }
  ll_insert(&terminals,node->match_result,0);
  ll_insert(&output,node->output,0);
  ll_insert(&newGrf,node->subauto_open,0);
  ll_insert(&endGrf,node->subauto_close,0);
  length += node->length;
  weight *= node->weight;
  switch(context->application){
  case 0:
    app_tokenization(context,terminals,output,result);
    break;
  case 1:
    app_syntactic_analysis(context,terminals,output,newGrf,endGrf);
    break;
  default:
    ll_print_keys(terminals);
    ll_print_keys(output);
    ll_print_keys(newGrf);
    ll_print_keys(endGrf);
    break;
  }

  ll_free(&terminals);
  ll_free(&output); 
  ll_free(&newGrf); 
  ll_free(&endGrf); 

}

